/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.common.time.domain.TemporalTimestampListener;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.broadleafcommerce.profile.core.domain.CustomerRole;
import org.broadleafcommerce.profile.core.domain.Role;
import org.broadleafcommerce.profile.core.domain.RoleImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER_ROLE")
public class CustomerRoleImpl
implements CustomerRole {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CustomerRoleId")
    @GenericGenerator(name="CustomerRoleId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CustomerRoleImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.profile.core.domain.CustomerRoleImpl")})
    @Column(name="CUSTOMER_ROLE_ID")
    protected Long id;
    @ManyToOne(targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @Index(name="CUSTROLE_CUSTOMER_INDEX", columnNames={"CUSTOMER_ID"})
    protected Customer customer;
    @ManyToOne(targetEntity=RoleImpl.class, optional=false)
    @JoinColumn(name="ROLE_ID")
    @Index(name="CUSTROLE_ROLE_INDEX", columnNames={"ROLE_ID"})
    protected Role role;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public String getRoleName() {
        return this.role.getRoleName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CustomerRoleImpl other = (CustomerRoleImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }
}

