/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CustomerPaymentDao;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.broadleafcommerce.profile.core.domain.CustomerPaymentImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerPaymentDao")
public class CustomerPaymentDaoImpl
implements CustomerPaymentDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public List<CustomerPayment> readCustomerPaymentsByCustomerId(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_PAYMENTS_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public CustomerPayment save(CustomerPayment customerPayment) {
        return (CustomerPayment)this.em.merge((Object)customerPayment);
    }

    @Override
    public CustomerPayment readCustomerPaymentByToken(String token) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_PAYMENT_BY_TOKEN");
        query.setParameter("token", (Object)token);
        CustomerPayment payment = null;
        try {
            payment = (CustomerPayment)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return payment;
    }

    @Override
    public CustomerPayment readCustomerPaymentById(Long customerPaymentId) {
        return (CustomerPayment)this.em.find(CustomerPaymentImpl.class, (Object)customerPaymentId);
    }

    @Override
    public void deleteCustomerPaymentById(Long customerPaymentId) {
        CustomerPayment customerPayment = this.readCustomerPaymentById(customerPaymentId);
        if (customerPayment != null) {
            this.em.remove((Object)customerPayment);
        }
    }

    @Override
    public CustomerPayment create() {
        return (CustomerPayment)this.entityConfiguration.createEntityInstance(CustomerPayment.class.getName());
    }
}

