/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import javax.annotation.Resource;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.IdGenerationDao;
import org.broadleafcommerce.profile.core.domain.IdGeneration;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="blIdGenerationDao")
public class IdGenerationDaoImpl
implements IdGenerationDao {
    private static final Log LOG = LogFactory.getLog(IdGenerationDaoImpl.class);
    protected Long defaultBatchSize = 100L;
    protected Long defaultBatchStart = 1L;
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    @Transactional(value="blTransactionManager")
    public IdGeneration findNextId(String idType) throws OptimisticLockException, Exception {
        return this.findNextId(idType, null);
    }

    @Override
    @Transactional(value="blTransactionManager", propagation=Propagation.REQUIRES_NEW)
    public IdGeneration findNextId(String idType, Long batchSize) throws OptimisticLockException, Exception {
        IdGeneration response2;
        Query query = this.em.createNamedQuery("BC_FIND_NEXT_ID");
        query.setParameter("idType", (Object)idType);
        try {
            IdGeneration idGeneration = (IdGeneration)query.getSingleResult();
            response2 = (IdGeneration)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.core.domain.IdGeneration");
            response2.setBatchSize(idGeneration.getBatchSize());
            response2.setBatchStart(idGeneration.getBatchStart());
            Long originalBatchStart = idGeneration.getBatchStart();
            idGeneration.setBatchStart(originalBatchStart + idGeneration.getBatchSize());
            if (idGeneration.getBegin() != null) {
                response2.setBegin(idGeneration.getBegin());
                if (idGeneration.getBatchStart() < idGeneration.getBegin()) {
                    idGeneration.setBatchStart(idGeneration.getBegin());
                    response2.setBatchStart(idGeneration.getBatchStart());
                }
            }
            if (idGeneration.getEnd() != null) {
                response2.setEnd(idGeneration.getEnd());
                if (idGeneration.getBatchStart() > idGeneration.getEnd()) {
                    response2.setBatchSize(idGeneration.getEnd() - originalBatchStart + 1L);
                    if (idGeneration.getBegin() != null) {
                        idGeneration.setBatchStart(idGeneration.getBegin());
                    } else {
                        idGeneration.setBatchStart(this.getDefaultBatchStart());
                    }
                }
            }
            response2.setType(idGeneration.getType());
            this.em.merge((Object)idGeneration);
            this.em.flush();
        }
        catch (NoResultException nre) {
            block11: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No row found in idGenerator table for " + idType + " creating row."));
                }
                IdGeneration response2 = (IdGeneration)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.core.domain.IdGeneration");
                response2.setType(idType);
                response2.setBegin(null);
                response2.setEnd(null);
                response2.setBatchStart(this.getDefaultBatchStart());
                response2.setBatchSize(batchSize == null ? this.getDefaultBatchSize() : batchSize);
                try {
                    this.em.persist((Object)response2);
                    this.em.flush();
                }
                catch (EntityExistsException e) {
                    if (!LOG.isWarnEnabled()) break block11;
                    LOG.warn((Object)("Error inserting row id generation for idType " + idType + ".  Requerying table."));
                }
            }
            return this.findNextId(idType);
        }
        return response2;
    }

    public Long getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(Long defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public Long getDefaultBatchStart() {
        return this.defaultBatchStart;
    }

    public void setDefaultBatchStart(Long defaultBatchStart) {
        this.defaultBatchStart = defaultBatchStart;
    }
}

