/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerDao")
public class CustomerDaoImpl
implements CustomerDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Customer readCustomerById(Long id) {
        return (Customer)this.em.find(CustomerImpl.class, (Object)id);
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        return this.readCustomerByUsername(username, true);
    }

    @Override
    public Customer readCustomerByUsername(String username, Boolean cacheable) {
        List<Customer> customers = this.readCustomersByUsername(username, cacheable);
        return CollectionUtils.isEmpty(customers) ? null : customers.get(0);
    }

    @Override
    public List<Customer> readCustomersByUsername(String username) {
        return this.readCustomersByUsername(username, true);
    }

    @Override
    public List<Customer> readCustomersByUsername(String username, Boolean cacheable) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_USER_NAME", Customer.class);
        query.setParameter("username", (Object)username);
        query.setHint("org.hibernate.cacheable", (Object)cacheable);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Order");
        return query.getResultList();
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        List<Customer> customers = this.readCustomersByEmail(emailAddress);
        return CollectionUtils.isEmpty(customers) ? null : customers.get(0);
    }

    @Override
    public List<Customer> readCustomersByEmail(String emailAddress) {
        TypedQuery query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_EMAIL", Customer.class);
        query.setParameter("email", (Object)emailAddress);
        query.setHint("org.hibernate.cacheable", (Object)true);
        query.setHint("org.hibernate.cacheRegion", (Object)"query.Order");
        return query.getResultList();
    }

    @Override
    public Customer save(Customer customer) {
        return (Customer)this.em.merge((Object)customer);
    }

    @Override
    public Customer create() {
        Customer customer = (Customer)this.entityConfiguration.createEntityInstance(Customer.class.getName());
        return customer;
    }

    @Override
    public void delete(Customer customer) {
        if (!this.em.contains((Object)customer)) {
            customer = this.readCustomerById(customer.getId());
        }
        this.em.remove((Object)customer);
    }
}

