/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.dao.CustomerPaymentDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.broadleafcommerce.profile.core.service.CustomerPaymentService;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blCustomerPaymentService")
public class CustomerPaymentServiceImpl
implements CustomerPaymentService {
    @Resource(name="blCustomerPaymentDao")
    protected CustomerPaymentDao customerPaymentDao;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;

    @Override
    @Transactional(value="blTransactionManager")
    public CustomerPayment saveCustomerPayment(CustomerPayment customerPayment) {
        return this.customerPaymentDao.save(customerPayment);
    }

    @Override
    public List<CustomerPayment> readCustomerPaymentsByCustomerId(Long customerId) {
        return this.customerPaymentDao.readCustomerPaymentsByCustomerId(customerId);
    }

    @Override
    public CustomerPayment readCustomerPaymentById(Long customerPaymentId) {
        return this.customerPaymentDao.readCustomerPaymentById(customerPaymentId);
    }

    @Override
    public CustomerPayment readCustomerPaymentByToken(String token) {
        return this.customerPaymentDao.readCustomerPaymentByToken(token);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void deleteCustomerPaymentById(Long customerPaymentId) {
        this.customerPaymentDao.deleteCustomerPaymentById(customerPaymentId);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public CustomerPayment create() {
        return this.customerPaymentDao.create();
    }

    @Override
    public CustomerPayment findDefaultPaymentForCustomer(Customer customer) {
        if (customer == null) {
            return null;
        }
        List<CustomerPayment> payments = this.readCustomerPaymentsByCustomerId(customer.getId());
        for (CustomerPayment payment : payments) {
            if (!payment.isDefault()) continue;
            return payment;
        }
        return null;
    }

    @Override
    @Transactional(value="blTransactionManager")
    public CustomerPayment setAsDefaultPayment(CustomerPayment payment) {
        CustomerPayment oldDefault = this.findDefaultPaymentForCustomer(payment.getCustomer());
        if (oldDefault != null) {
            oldDefault.setDefault(false);
            this.saveCustomerPayment(oldDefault);
        }
        payment.setDefault(true);
        return this.saveCustomerPayment(payment);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Customer deleteCustomerPaymentFromCustomer(Customer customer, CustomerPayment payment) {
        List<CustomerPayment> payments = customer.getCustomerPayments();
        for (CustomerPayment customerPayment : payments) {
            if (!customerPayment.getId().equals(payment.getId())) continue;
            customer.getCustomerPayments().remove(customerPayment);
            break;
        }
        return this.customerService.saveCustomer(customer);
    }
}

