/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PHONE")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class PhoneImpl
implements Phone {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PhoneId")
    @GenericGenerator(name="PhoneId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="PhoneImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.profile.core.domain.PhoneImpl")})
    @Column(name="PHONE_ID")
    protected Long id;
    @Column(name="COUNTRY_CODE")
    @AdminPresentation(friendlyName="PhoneImpl_Country_Code", order=1, group="PhoneImpl_Phone")
    protected String countryCode;
    @Column(name="PHONE_NUMBER", nullable=false)
    @AdminPresentation(friendlyName="PhoneImpl_Phone_Number", order=2, group="PhoneImpl_Phone")
    protected String phoneNumber;
    @Column(name="EXTENSION")
    @AdminPresentation(friendlyName="PhoneImpl_Extension", order=3, group="PhoneImpl_Phone")
    protected String extension;
    @Column(name="IS_DEFAULT")
    @AdminPresentation(friendlyName="PhoneImpl_Default_Phone", order=4, group="PhoneImpl_Phone")
    protected boolean isDefault = false;
    @Column(name="IS_ACTIVE")
    @AdminPresentation(friendlyName="PhoneImpl_Active_Phone", order=5, group="PhoneImpl_Phone")
    protected boolean isActive = true;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    @Override
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isActive ? 1231 : 1237);
        result = 31 * result + (this.isDefault ? 1231 : 1237);
        result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = 31 * result + (this.extension == null ? 0 : this.extension.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        PhoneImpl other = (PhoneImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.isActive != other.isActive) {
            return false;
        }
        if (this.isDefault != other.isDefault) {
            return false;
        }
        if (this.countryCode == null ? other.countryCode != null : !this.countryCode.equals(other.countryCode)) {
            return false;
        }
        if (this.phoneNumber == null ? other.phoneNumber != null : !this.phoneNumber.equals(other.phoneNumber)) {
            return false;
        }
        return !(this.extension == null ? other.extension != null : !this.extension.equals(other.extension));
    }
}

