/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service.validator;

import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component(value="blResetPasswordValidator")
public class ResetPasswordValidator
implements Validator {
    private String validPasswordRegex = "[0-9A-Za-z]{4,15}";

    public void validate(String username, String password, String confirmPassword, Errors errors) {
        if (password == null || "".equals(password)) {
            errors.reject("password", "password.required");
        }
        if (username == null || "".equals(username)) {
            errors.reject("username", "username.required");
        }
        if (!errors.hasErrors()) {
            if (!password.matches(this.validPasswordRegex)) {
                errors.rejectValue("password", "password.invalid", null, null);
            } else if (!password.equals(confirmPassword)) {
                errors.rejectValue("password", "passwordConfirm.invalid", null, null);
            }
        }
    }

    public boolean supports(Class<?> clazz) {
        return false;
    }

    public void validate(Object target, Errors errors) {
    }

    public String getValidPasswordRegex() {
        return this.validPasswordRegex;
    }

    public void setValidPasswordRegex(String validPasswordRegex) {
        this.validPasswordRegex = validPasswordRegex;
    }
}

