/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerRole;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.CustomerUserDetails;
import org.broadleafcommerce.profile.core.service.RoleService;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service(value="blUserDetailsService")
public class UserDetailsServiceImpl
implements UserDetailsService {
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blRoleService")
    protected RoleService roleService;

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        Customer customer = this.customerService.readCustomerByUsername(username, false);
        if (customer == null) {
            throw new UsernameNotFoundException("The customer was not found");
        }
        List<GrantedAuthority> grantedAuthorities = this.createGrantedAuthorities(this.roleService.findCustomerRolesByCustomerId(customer.getId()));
        return new CustomerUserDetails(customer.getId(), username, customer.getPassword(), !customer.isDeactivated(), true, !customer.isPasswordChangeRequired(), true, grantedAuthorities);
    }

    protected List<GrantedAuthority> createGrantedAuthorities(List<CustomerRole> customerRoles) {
        boolean roleUserFound = false;
        ArrayList<GrantedAuthority> grantedAuthorities = new ArrayList<GrantedAuthority>();
        for (CustomerRole role : customerRoles) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(role.getRoleName()));
            if (!role.getRoleName().equals("ROLE_USER")) continue;
            roleUserFound = true;
        }
        if (!roleUserFound) {
            grantedAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        }
        return grantedAuthorities;
    }
}

