/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.config.domain.ModuleConfiguration;
import org.broadleafcommerce.common.config.service.ModuleConfigurationService;
import org.broadleafcommerce.common.config.service.type.ModuleConfigurationType;
import org.broadleafcommerce.profile.core.dao.AddressDao;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.broadleafcommerce.profile.core.service.AddressVerificationProvider;
import org.broadleafcommerce.profile.core.service.exception.AddressVerificationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="blAddressService")
public class AddressServiceImpl
implements AddressService {
    protected boolean mustValidateAddresses = false;
    @Resource(name="blAddressDao")
    protected AddressDao addressDao;
    @Resource(name="blModuleConfigurationService")
    protected ModuleConfigurationService moduleConfigService;
    @Resource(name="blAddressVerificationProviders")
    protected List<AddressVerificationProvider> providers;

    @Override
    @Transactional(value="blTransactionManager")
    public Address saveAddress(Address address) {
        return this.addressDao.save(address);
    }

    @Override
    public Address readAddressById(Long addressId) {
        return this.addressDao.readAddressById(addressId);
    }

    @Override
    @Transactional(value="blTransactionManager")
    public Address create() {
        return this.addressDao.create();
    }

    @Override
    @Transactional(value="blTransactionManager")
    public void delete(Address address) {
        this.addressDao.delete(address);
    }

    @Override
    public List<Address> verifyAddress(Address address) throws AddressVerificationException {
        List moduleConfigs;
        if (address.getStandardized() != null && Boolean.TRUE.equals(address.getStandardized())) {
            ArrayList<Address> out = new ArrayList<Address>();
            out.add(address);
            return out;
        }
        if (this.providers != null && !this.providers.isEmpty() && (moduleConfigs = this.moduleConfigService.findActiveConfigurationsByType(ModuleConfigurationType.ADDRESS_VERIFICATION)) != null && !moduleConfigs.isEmpty()) {
            ModuleConfiguration config = null;
            for (ModuleConfiguration configuration : moduleConfigs) {
                if (!configuration.getIsDefault().booleanValue()) continue;
                config = configuration;
                break;
            }
            if (config == null) {
                config = (ModuleConfiguration)moduleConfigs.get(0);
            }
            for (AddressVerificationProvider provider : this.providers) {
                if (!provider.canRespond(config)) continue;
                return provider.validateAddress(address, config);
            }
        }
        if (this.mustValidateAddresses) {
            throw new AddressVerificationException("No providers were configured to handle address validation");
        }
        ArrayList<Address> out = new ArrayList<Address>();
        out.add(address);
        return out;
    }

    public void setMustValidateAddresses(boolean mustValidateAddresses) {
        this.mustValidateAddresses = mustValidateAddresses;
    }
}

