/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.common.time.domain.TemporalTimestampListener;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.broadleafcommerce.profile.core.domain.CustomerPayment;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER_PAYMENT", uniqueConstraints={@UniqueConstraint(name="CSTMR_PAY_UNIQUE_CNSTRNT", columnNames={"CUSTOMER_ID", "PAYMENT_TOKEN"})})
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="billingAddress.addressLine1", mergeEntries={@AdminPresentationMergeEntry(propertyType="prominent", booleanOverrideValue=true)})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE)
public class CustomerPaymentImpl
implements CustomerPayment {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CustomerPaymentId")
    @GenericGenerator(name="CustomerPaymentId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CustomerPaymentImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.profile.core.domain.CustomerPaymentImpl")})
    @Column(name="CUSTOMER_PAYMENT_ID")
    protected Long id;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @AdminPresentation(excluded=true)
    protected Customer customer;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=AddressImpl.class, optional=false)
    @JoinColumn(name="ADDRESS_ID")
    protected Address billingAddress;
    @Column(name="PAYMENT_TOKEN")
    protected String paymentToken;
    @Column(name="IS_DEFAULT")
    protected boolean isDefault = false;
    @ElementCollection
    @CollectionTable(name="BLC_CUSTOMER_PAYMENT_FIELDS", joinColumns={@JoinColumn(name="CUSTOMER_PAYMENT_ID")})
    @MapKeyColumn(name="FIELD_NAME", nullable=false)
    @Column(name="FIELD_VALUE")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
    protected Map<String, String> additionalFields = new HashMap<String, String>();

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public Address getBillingAddress() {
        return this.billingAddress;
    }

    @Override
    public void setBillingAddress(Address billingAddress) {
        this.billingAddress = billingAddress;
    }

    @Override
    public String getPaymentToken() {
        return this.paymentToken;
    }

    @Override
    public void setPaymentToken(String paymentToken) {
        this.paymentToken = paymentToken;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    @Override
    public Map<String, String> getAdditionalFields() {
        return this.additionalFields;
    }

    @Override
    public void setAdditionalFields(Map<String, String> additionalFields) {
        this.additionalFields = additionalFields;
    }
}

