/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.email.service.EmailService;
import org.broadleafcommerce.common.email.service.info.EmailInfo;
import org.broadleafcommerce.common.security.util.PasswordChange;
import org.broadleafcommerce.common.security.util.PasswordReset;
import org.broadleafcommerce.common.security.util.PasswordUtils;
import org.broadleafcommerce.common.service.GenericResponse;
import org.broadleafcommerce.common.time.SystemTime;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.dao.CustomerForgotPasswordSecurityTokenDao;
import org.broadleafcommerce.profile.core.dao.RoleDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerForgotPasswordSecurityToken;
import org.broadleafcommerce.profile.core.domain.CustomerForgotPasswordSecurityTokenImpl;
import org.broadleafcommerce.profile.core.domain.CustomerRoleImpl;
import org.broadleafcommerce.profile.core.domain.Role;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.CustomerUserDetails;
import org.broadleafcommerce.profile.core.service.IdGenerationService;
import org.broadleafcommerce.profile.core.service.handler.PasswordUpdatedHandler;
import org.broadleafcommerce.profile.core.service.listener.PostRegistrationObserver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;

@Service(value="blCustomerService")
public class CustomerServiceImpl
implements CustomerService {
    private static final Log LOG = LogFactory.getLog(CustomerServiceImpl.class);
    @Resource(name="blCustomerDao")
    protected CustomerDao customerDao;
    @Resource(name="blIdGenerationService")
    protected IdGenerationService idGenerationService;
    @Resource(name="blCustomerForgotPasswordSecurityTokenDao")
    protected CustomerForgotPasswordSecurityTokenDao customerForgotPasswordSecurityTokenDao;
    @Resource(name="blPasswordEncoder")
    protected PasswordEncoder passwordEncoder;
    @Deprecated
    protected String salt;
    @Autowired(required=false)
    @Qualifier(value="blSaltSource")
    protected SaltSource saltSource;
    @Resource(name="blRoleDao")
    protected RoleDao roleDao;
    @Resource(name="blEmailService")
    protected EmailService emailService;
    @Resource(name="blForgotPasswordEmailInfo")
    protected EmailInfo forgotPasswordEmailInfo;
    @Resource(name="blForgotUsernameEmailInfo")
    protected EmailInfo forgotUsernameEmailInfo;
    @Resource(name="blRegistrationEmailInfo")
    protected EmailInfo registrationEmailInfo;
    @Resource(name="blChangePasswordEmailInfo")
    protected EmailInfo changePasswordEmailInfo;
    protected int tokenExpiredMinutes = 30;
    protected int passwordTokenLength = 20;
    protected final List<PostRegistrationObserver> postRegisterListeners = new ArrayList<PostRegistrationObserver>();
    protected List<PasswordUpdatedHandler> passwordResetHandlers = new ArrayList<PasswordUpdatedHandler>();
    protected List<PasswordUpdatedHandler> passwordChangedHandlers = new ArrayList<PasswordUpdatedHandler>();

    @Override
    public Customer saveCustomer(Customer customer) {
        return this.saveCustomer(customer, customer.isRegistered());
    }

    @Override
    public Customer saveCustomer(Customer customer, boolean register) {
        if (register && !customer.isRegistered()) {
            customer.setRegistered(true);
        }
        if (customer.getUnencodedPassword() != null) {
            customer.setPassword(this.encodePassword(customer.getUnencodedPassword(), customer));
        }
        if (customer.getUnencodedChallengeAnswer() != null && !customer.getUnencodedChallengeAnswer().equals(customer.getChallengeAnswer())) {
            customer.setChallengeAnswer(this.encodePassword(customer.getUnencodedChallengeAnswer(), customer));
        }
        return this.customerDao.save(customer);
    }

    protected String generateSecurePassword() {
        return RandomStringUtils.randomAlphanumeric((int)16);
    }

    @Override
    public Customer registerCustomer(Customer customer, String password, String passwordConfirm) {
        customer.setRegistered(true);
        if (customer.getId() == null) {
            customer.setId(this.findNextCustomerId());
        }
        customer.setUnencodedPassword(password);
        Customer retCustomer = this.saveCustomer(customer);
        this.createRegisteredCustomerRoles(retCustomer);
        HashMap<String, Customer> vars = new HashMap<String, Customer>();
        vars.put("customer", retCustomer);
        this.emailService.sendTemplateEmail(customer.getEmailAddress(), this.getRegistrationEmailInfo(), vars);
        this.notifyPostRegisterListeners(retCustomer);
        return retCustomer;
    }

    protected void createRegisteredCustomerRoles(Customer customer) {
        Role role = this.roleDao.readRoleByName("ROLE_USER");
        CustomerRoleImpl customerRole = new CustomerRoleImpl();
        customerRole.setRole(role);
        customerRole.setCustomer(customer);
        this.roleDao.addRoleToCustomer(customerRole);
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        return this.customerDao.readCustomerByEmail(emailAddress);
    }

    @Override
    public Customer changePassword(PasswordChange passwordChange) {
        Customer customer = this.readCustomerByUsername(passwordChange.getUsername());
        customer.setUnencodedPassword(passwordChange.getNewPassword());
        customer.setPasswordChangeRequired(passwordChange.getPasswordChangeRequired());
        customer = this.saveCustomer(customer);
        for (PasswordUpdatedHandler handler : this.passwordChangedHandlers) {
            handler.passwordChanged((PasswordReset)passwordChange, customer, passwordChange.getNewPassword());
        }
        return customer;
    }

    @Override
    public Customer resetPassword(PasswordReset passwordReset) {
        Customer customer = this.readCustomerByUsername(passwordReset.getUsername());
        String newPassword = PasswordUtils.generateTemporaryPassword((int)passwordReset.getPasswordLength());
        customer.setUnencodedPassword(newPassword);
        customer.setPasswordChangeRequired(passwordReset.getPasswordChangeRequired());
        customer = this.saveCustomer(customer);
        for (PasswordUpdatedHandler handler : this.passwordResetHandlers) {
            handler.passwordChanged(passwordReset, customer, newPassword);
        }
        return customer;
    }

    @Override
    public void addPostRegisterListener(PostRegistrationObserver postRegisterListeners) {
        this.postRegisterListeners.add(postRegisterListeners);
    }

    @Override
    public void removePostRegisterListener(PostRegistrationObserver postRegisterListeners) {
        if (this.postRegisterListeners.contains(postRegisterListeners)) {
            this.postRegisterListeners.remove(postRegisterListeners);
        }
    }

    protected void notifyPostRegisterListeners(Customer customer) {
        for (PostRegistrationObserver listener : this.postRegisterListeners) {
            listener.processRegistrationEvent(customer);
        }
    }

    @Override
    public Customer createCustomer() {
        return this.createCustomerFromId(null);
    }

    @Override
    public Customer createCustomerFromId(Long customerId) {
        Customer customer;
        Customer customer2 = customer = customerId != null ? this.readCustomerById(customerId) : null;
        if (customer == null) {
            customer = this.customerDao.create();
            if (customerId != null) {
                customer.setId(customerId);
            } else {
                customer.setId(this.findNextCustomerId());
            }
        }
        return customer;
    }

    @Override
    public Long findNextCustomerId() {
        return this.idGenerationService.findNextId("org.broadleafcommerce.profile.core.domain.Customer");
    }

    @Override
    public Customer createNewCustomer() {
        return this.createCustomerFromId(null);
    }

    @Override
    public void deleteCustomer(Customer customer) {
        this.customerDao.delete(customer);
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        return this.customerDao.readCustomerByUsername(username);
    }

    @Override
    public Customer readCustomerByUsername(String username, Boolean cacheable) {
        return this.customerDao.readCustomerByUsername(username, cacheable);
    }

    @Override
    public Customer readCustomerById(Long id) {
        return this.customerDao.readCustomerById(id);
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    @Deprecated
    public Object getSalt(Customer customer) {
        return this.getSalt(customer, "");
    }

    @Override
    public Object getSalt(Customer customer, String unencodedPassword) {
        Object salt = null;
        if (this.saltSource != null && customer != null) {
            salt = this.saltSource.getSalt((UserDetails)new CustomerUserDetails(customer.getId(), customer.getUsername(), unencodedPassword, new ArrayList()));
        }
        return salt;
    }

    @Override
    public String encodePassword(String clearText, Customer customer) {
        return this.passwordEncoder.encodePassword(clearText, this.getSalt(customer, clearText));
    }

    @Override
    public boolean isPasswordValid(String rawPassword, String encodedPassword, Customer customer) {
        return this.passwordEncoder.isPasswordValid(encodedPassword, rawPassword, this.getSalt(customer, rawPassword));
    }

    @Override
    @Deprecated
    public String getSalt() {
        return this.salt;
    }

    @Override
    @Deprecated
    public void setSalt(String salt) {
        this.salt = salt;
    }

    @Override
    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    @Override
    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    @Override
    public List<PasswordUpdatedHandler> getPasswordResetHandlers() {
        return this.passwordResetHandlers;
    }

    @Override
    public void setPasswordResetHandlers(List<PasswordUpdatedHandler> passwordResetHandlers) {
        this.passwordResetHandlers = passwordResetHandlers;
    }

    @Override
    public List<PasswordUpdatedHandler> getPasswordChangedHandlers() {
        return this.passwordChangedHandlers;
    }

    @Override
    public void setPasswordChangedHandlers(List<PasswordUpdatedHandler> passwordChangedHandlers) {
        this.passwordChangedHandlers = passwordChangedHandlers;
    }

    @Override
    public GenericResponse sendForgotUsernameNotification(String emailAddress) {
        GenericResponse response = new GenericResponse();
        List<Customer> customers = null;
        if (emailAddress != null) {
            customers = this.customerDao.readCustomersByEmail(emailAddress);
        }
        if (customers == null || customers.isEmpty()) {
            response.addErrorCode("notFound");
        } else {
            ArrayList<String> activeUsernames = new ArrayList<String>();
            for (Customer customer : customers) {
                if (customer.isDeactivated()) continue;
                activeUsernames.add(customer.getUsername());
            }
            if (activeUsernames.size() > 0) {
                HashMap<String, ArrayList<String>> vars = new HashMap<String, ArrayList<String>>();
                vars.put("userNames", activeUsernames);
                this.emailService.sendTemplateEmail(emailAddress, this.getForgotUsernameEmailInfo(), vars);
            } else {
                response.addErrorCode("inactiveUser");
            }
        }
        return response;
    }

    @Override
    public GenericResponse sendForgotPasswordNotification(String username, String resetPasswordUrl) {
        GenericResponse response = new GenericResponse();
        Customer customer = null;
        if (username != null) {
            customer = this.customerDao.readCustomerByUsername(username);
        }
        this.checkCustomer(customer, response);
        if (!response.getHasErrors()) {
            String token = PasswordUtils.generateTemporaryPassword((int)this.getPasswordTokenLength());
            token = token.toLowerCase();
            Object salt = this.getSalt(customer, token);
            String saltString = null;
            if (salt != null) {
                saltString = Hex.encodeHexString((byte[])salt.toString().getBytes());
            }
            CustomerForgotPasswordSecurityTokenImpl fpst = new CustomerForgotPasswordSecurityTokenImpl();
            fpst.setCustomerId(customer.getId());
            fpst.setToken(this.passwordEncoder.encodePassword(token, (Object)saltString));
            fpst.setCreateDate(SystemTime.asDate());
            this.customerForgotPasswordSecurityTokenDao.saveToken(fpst);
            if (saltString != null) {
                token = token + '-' + saltString;
            }
            HashMap<String, String> vars = new HashMap<String, String>();
            vars.put("token", token);
            if (!StringUtils.isEmpty((String)resetPasswordUrl)) {
                resetPasswordUrl = resetPasswordUrl.contains("?") ? resetPasswordUrl + "&token=" + token : resetPasswordUrl + "?token=" + token;
            }
            vars.put("resetPasswordUrl", resetPasswordUrl);
            this.emailService.sendTemplateEmail(customer.getEmailAddress(), this.getForgotPasswordEmailInfo(), vars);
        }
        return response;
    }

    @Override
    public GenericResponse checkPasswordResetToken(String token) {
        GenericResponse response = new GenericResponse();
        this.checkPasswordResetToken(token, response);
        return response;
    }

    protected CustomerForgotPasswordSecurityToken checkPasswordResetToken(String token, GenericResponse response) {
        if (token == null || "".equals(token)) {
            response.addErrorCode("invalidToken");
        }
        String rawToken = null;
        String salt = null;
        String[] tokens = token.split("-");
        if (tokens.length > 2) {
            response.addErrorCode("invalidToken");
        } else {
            rawToken = tokens[0].toLowerCase();
            if (tokens.length == 2) {
                salt = tokens[1];
            }
        }
        CustomerForgotPasswordSecurityToken fpst = null;
        if (!response.getHasErrors()) {
            fpst = this.customerForgotPasswordSecurityTokenDao.readToken(this.passwordEncoder.encodePassword(rawToken, (Object)salt));
            if (fpst == null) {
                response.addErrorCode("invalidToken");
            } else if (fpst.isTokenUsedFlag()) {
                response.addErrorCode("tokenUsed");
            } else if (this.isTokenExpired(fpst)) {
                response.addErrorCode("tokenExpired");
            }
        }
        return fpst;
    }

    @Override
    public GenericResponse resetPasswordUsingToken(String username, String token, String password, String confirmPassword) {
        GenericResponse response = new GenericResponse();
        Customer customer = null;
        if (username != null) {
            customer = this.customerDao.readCustomerByUsername(username);
        }
        this.checkCustomer(customer, response);
        this.checkPassword(password, confirmPassword, response);
        CustomerForgotPasswordSecurityToken fpst = this.checkPasswordResetToken(token, response);
        if (!response.getHasErrors() && !customer.getId().equals(fpst.getCustomerId())) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("Password reset attempt tried with mismatched customer and token " + customer.getId() + ", " + token));
            }
            response.addErrorCode("invalidToken");
        }
        if (!response.getHasErrors()) {
            customer.setUnencodedPassword(password);
            this.saveCustomer(customer);
            fpst.setTokenUsedFlag(true);
            this.customerForgotPasswordSecurityTokenDao.saveToken(fpst);
        }
        return response;
    }

    protected void checkCustomer(Customer customer, GenericResponse response) {
        if (customer == null) {
            response.addErrorCode("invalidCustomer");
        } else if (customer.getEmailAddress() == null || "".equals(customer.getEmailAddress())) {
            response.addErrorCode("emailNotFound");
        } else if (customer.isDeactivated()) {
            response.addErrorCode("inactiveUser");
        }
    }

    protected void checkPassword(String password, String confirmPassword, GenericResponse response) {
        if (password == null || confirmPassword == null || "".equals(password) || "".equals(confirmPassword)) {
            response.addErrorCode("invalidPassword");
        } else if (!password.equals(confirmPassword)) {
            response.addErrorCode("passwordMismatch");
        }
    }

    protected boolean isTokenExpired(CustomerForgotPasswordSecurityToken fpst) {
        long tokenSaveTimeInMillis;
        Date now = SystemTime.asDate();
        long currentTimeInMillis = now.getTime();
        long minutesSinceSave = (currentTimeInMillis - (tokenSaveTimeInMillis = fpst.getCreateDate().getTime())) / 60000L;
        return minutesSinceSave > (long)this.tokenExpiredMinutes;
    }

    public int getTokenExpiredMinutes() {
        return this.tokenExpiredMinutes;
    }

    public void setTokenExpiredMinutes(int tokenExpiredMinutes) {
        this.tokenExpiredMinutes = tokenExpiredMinutes;
    }

    public int getPasswordTokenLength() {
        return this.passwordTokenLength;
    }

    public void setPasswordTokenLength(int passwordTokenLength) {
        this.passwordTokenLength = passwordTokenLength;
    }

    public EmailInfo getForgotPasswordEmailInfo() {
        return this.forgotPasswordEmailInfo;
    }

    public void setForgotPasswordEmailInfo(EmailInfo forgotPasswordEmailInfo) {
        this.forgotPasswordEmailInfo = forgotPasswordEmailInfo;
    }

    public EmailInfo getForgotUsernameEmailInfo() {
        return this.forgotUsernameEmailInfo;
    }

    public void setForgotUsernameEmailInfo(EmailInfo forgotUsernameEmailInfo) {
        this.forgotUsernameEmailInfo = forgotUsernameEmailInfo;
    }

    public EmailInfo getRegistrationEmailInfo() {
        return this.registrationEmailInfo;
    }

    public void setRegistrationEmailInfo(EmailInfo registrationEmailInfo) {
        this.registrationEmailInfo = registrationEmailInfo;
    }

    public EmailInfo getChangePasswordEmailInfo() {
        return this.changePasswordEmailInfo;
    }

    public void setChangePasswordEmailInfo(EmailInfo changePasswordEmailInfo) {
        this.changePasswordEmailInfo = changePasswordEmailInfo;
    }
}

