/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.common.presentation.PopulateToOneFieldsEnum;
import org.broadleafcommerce.common.presentation.client.VisibilityEnum;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeEntry;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverride;
import org.broadleafcommerce.common.presentation.override.AdminPresentationMergeOverrides;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Parameter;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER_PHONE", uniqueConstraints={@UniqueConstraint(name="CSTMR_PHONE_UNIQUE_CNSTRNT", columnNames={"CUSTOMER_ID", "PHONE_NAME"})})
@AdminPresentationMergeOverrides(value={@AdminPresentationMergeOverride(name="phone.phoneNumber", mergeEntries={@AdminPresentationMergeEntry(propertyType="prominent", booleanOverrideValue=true)})})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE)
public class CustomerPhoneImpl
implements CustomerPhone {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CustomerPhoneId")
    @GenericGenerator(name="CustomerPhoneId", strategy="org.broadleafcommerce.common.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="segment_value", value="CustomerPhoneImpl"), @Parameter(name="entity_name", value="org.broadleafcommerce.profile.core.domain.CustomerPhoneImpl")})
    @Column(name="CUSTOMER_PHONE_ID")
    protected Long id;
    @Column(name="PHONE_NAME")
    @AdminPresentation(friendlyName="CustomerPhoneImpl_Phone_Name", order=1, group="CustomerPhoneImpl_Identification", groupOrder=1, prominent=true, gridOrder=1)
    protected String phoneName;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    @AdminPresentation(excluded=true, visibility=VisibilityEnum.HIDDEN_ALL)
    protected Customer customer;
    @ManyToOne(cascade={CascadeType.ALL}, targetEntity=PhoneImpl.class, optional=false)
    @JoinColumn(name="PHONE_ID")
    @Index(name="CUSTPHONE_PHONE_INDEX", columnNames={"PHONE_ID"})
    protected Phone phone;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getPhoneName() {
        return this.phoneName;
    }

    @Override
    public void setPhoneName(String phoneName) {
        this.phoneName = phoneName;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public Phone getPhone() {
        return this.phone;
    }

    @Override
    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        result = 31 * result + (this.phone == null ? 0 : this.phone.hashCode());
        result = 31 * result + (this.phoneName == null ? 0 : this.phoneName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CustomerPhoneImpl other = (CustomerPhoneImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        if (this.phone == null ? other.phone != null : !this.phone.equals(other.phone)) {
            return false;
        }
        return !(this.phoneName == null ? other.phoneName != null : !this.phoneName.equals(other.phoneName));
    }
}

