/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.presentation.AdminPresentationClass;
import org.broadleafcommerce.profile.core.domain.Country;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_COUNTRY")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blStandardElements")
@AdminPresentationClass(friendlyName="CountryImpl_baseCountry")
public class CountryImpl
implements Country {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ABBREVIATION")
    protected String abbreviation;
    @Column(name="NAME", nullable=false)
    @AdminPresentation(friendlyName="CountryImpl_Country", order=12, group="CountryImpl_Address", prominent=true)
    protected String name;

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public void setAbbreviation(String Abbreviation) {
        this.abbreviation = Abbreviation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        CountryImpl other = (CountryImpl)obj;
        if (this.abbreviation == null ? other.abbreviation != null : !this.abbreviation.equals(other.abbreviation)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abbreviation == null ? 0 : this.abbreviation.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

