/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.common.persistence.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerDao")
public class CustomerDaoImpl
implements CustomerDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Customer readCustomerById(Long id) {
        return (Customer)this.em.find(CustomerImpl.class, (Object)id);
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        List<Customer> customers = this.readCustomersByUsername(username);
        return customers == null || customers.isEmpty() ? null : customers.get(0);
    }

    @Override
    public List<Customer> readCustomersByUsername(String username) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_USER_NAME");
        query.setParameter("username", (Object)username);
        return query.getResultList();
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        List<Customer> customers = this.readCustomersByEmail(emailAddress);
        return customers == null || customers.isEmpty() ? null : customers.get(0);
    }

    @Override
    public List<Customer> readCustomersByEmail(String emailAddress) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_EMAIL");
        query.setParameter("email", (Object)emailAddress);
        return query.getResultList();
    }

    @Override
    public Customer save(Customer customer) {
        return (Customer)this.em.merge((Object)customer);
    }

    @Override
    public Customer create() {
        Customer customer = (Customer)this.entityConfiguration.createEntityInstance(Customer.class.getName());
        return customer;
    }
}

