/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.common.security.util.PasswordChange;
import org.broadleafcommerce.common.security.util.PasswordReset;
import org.broadleafcommerce.common.security.util.PasswordUtils;
import org.broadleafcommerce.profile.core.dao.CustomerDao;
import org.broadleafcommerce.profile.core.dao.RoleDao;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerRoleImpl;
import org.broadleafcommerce.profile.core.domain.Role;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.core.service.IdGenerationService;
import org.broadleafcommerce.profile.core.service.handler.PasswordUpdatedHandler;
import org.broadleafcommerce.profile.core.service.listener.PostRegistrationObserver;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service(value="blCustomerService")
public class CustomerServiceImpl
implements CustomerService {
    @Resource(name="blCustomerDao")
    protected CustomerDao customerDao;
    @Resource(name="blIdGenerationService")
    protected IdGenerationService idGenerationService;
    @Resource(name="blPasswordEncoder")
    protected PasswordEncoder passwordEncoder;
    @Resource(name="blRoleDao")
    protected RoleDao roleDao;
    protected final List<PostRegistrationObserver> postRegisterListeners = new ArrayList<PostRegistrationObserver>();
    protected List<PasswordUpdatedHandler> passwordResetHandlers = new ArrayList<PasswordUpdatedHandler>();
    protected List<PasswordUpdatedHandler> passwordChangedHandlers = new ArrayList<PasswordUpdatedHandler>();

    @Override
    public Customer saveCustomer(Customer customer) {
        return this.saveCustomer(customer, true);
    }

    @Override
    public Customer saveCustomer(Customer customer, boolean register) {
        if (register && !customer.isRegistered()) {
            customer.setRegistered(true);
        }
        if (customer.getUnencodedPassword() != null) {
            customer.setPassword(this.passwordEncoder.encodePassword(customer.getUnencodedPassword(), null));
        }
        if (customer.getUnencodedChallengeAnswer() != null && !customer.getUnencodedChallengeAnswer().equals(customer.getChallengeAnswer())) {
            customer.setChallengeAnswer(this.passwordEncoder.encodePassword(customer.getUnencodedChallengeAnswer(), null));
        }
        return this.customerDao.save(customer);
    }

    @Override
    public Customer registerCustomer(Customer customer, String password, String passwordConfirm) {
        customer.setRegistered(true);
        if (customer.getId() == null) {
            customer.setId(this.idGenerationService.findNextId("org.broadleafcommerce.profile.core.domain.Customer"));
        }
        customer.setUnencodedPassword(password);
        Customer retCustomer = this.saveCustomer(customer);
        Role role = this.roleDao.readRoleByName("ROLE_USER");
        CustomerRoleImpl customerRole = new CustomerRoleImpl();
        customerRole.setRole(role);
        customerRole.setCustomer(retCustomer);
        this.roleDao.addRoleToCustomer(customerRole);
        this.notifyPostRegisterListeners(retCustomer);
        return retCustomer;
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        return this.customerDao.readCustomerByEmail(emailAddress);
    }

    @Override
    public Customer changePassword(PasswordChange passwordChange) {
        Customer customer = this.readCustomerByUsername(passwordChange.getUsername());
        customer.setUnencodedPassword(passwordChange.getNewPassword());
        customer.setPasswordChangeRequired(passwordChange.getPasswordChangeRequired());
        customer = this.saveCustomer(customer);
        for (PasswordUpdatedHandler handler : this.passwordChangedHandlers) {
            handler.passwordChanged((PasswordReset)passwordChange, customer, passwordChange.getNewPassword());
        }
        return customer;
    }

    @Override
    public Customer resetPassword(PasswordReset passwordReset) {
        Customer customer = this.readCustomerByUsername(passwordReset.getUsername());
        String newPassword = PasswordUtils.generateTemporaryPassword((int)passwordReset.getPasswordLength());
        customer.setUnencodedPassword(newPassword);
        customer.setPasswordChangeRequired(passwordReset.getPasswordChangeRequired());
        customer = this.saveCustomer(customer);
        for (PasswordUpdatedHandler handler : this.passwordResetHandlers) {
            handler.passwordChanged(passwordReset, customer, newPassword);
        }
        return customer;
    }

    @Override
    public void addPostRegisterListener(PostRegistrationObserver postRegisterListeners) {
        this.postRegisterListeners.add(postRegisterListeners);
    }

    @Override
    public void removePostRegisterListener(PostRegistrationObserver postRegisterListeners) {
        if (this.postRegisterListeners.contains(postRegisterListeners)) {
            this.postRegisterListeners.remove(postRegisterListeners);
        }
    }

    protected void notifyPostRegisterListeners(Customer customer) {
        for (PostRegistrationObserver listener : this.postRegisterListeners) {
            listener.processRegistrationEvent(customer);
        }
    }

    @Override
    public Customer createCustomer() {
        return this.createCustomerFromId(null);
    }

    @Override
    public Customer createCustomerFromId(Long customerId) {
        Customer customer;
        Customer customer2 = customer = customerId != null ? this.readCustomerById(customerId) : null;
        if (customer == null) {
            customer = this.customerDao.create();
            if (customerId != null) {
                customer.setId(customerId);
            } else {
                customer.setId(this.idGenerationService.findNextId("org.broadleafcommerce.profile.core.domain.Customer"));
            }
        }
        return customer;
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        return this.customerDao.readCustomerByUsername(username);
    }

    @Override
    public Customer readCustomerById(Long id) {
        return this.customerDao.readCustomerById(id);
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Override
    public List<PasswordUpdatedHandler> getPasswordResetHandlers() {
        return this.passwordResetHandlers;
    }

    @Override
    public void setPasswordResetHandlers(List<PasswordUpdatedHandler> passwordResetHandlers) {
        this.passwordResetHandlers = passwordResetHandlers;
    }

    @Override
    public List<PasswordUpdatedHandler> getPasswordChangedHandlers() {
        return this.passwordChangedHandlers;
    }

    @Override
    public void setPasswordChangedHandlers(List<PasswordUpdatedHandler> passwordChangedHandlers) {
        this.passwordChangedHandlers = passwordChangedHandlers;
    }
}

