/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.broadleafcommerce.common.time.domain.TemporalTimestampListener;
import org.broadleafcommerce.profile.core.domain.User;
import org.broadleafcommerce.profile.core.domain.UserRole;
import org.broadleafcommerce.profile.core.domain.UserRoleImpl;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_USER", uniqueConstraints={@UniqueConstraint(columnNames={"USER_NAME"})})
public class UserImpl
implements User {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="UserId", strategy=GenerationType.TABLE)
    @TableGenerator(name="UserId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="UserImpl", allocationSize=50)
    @Column(name="USER_ID")
    protected Long id;
    @Column(name="USER_NAME", nullable=false)
    protected String username;
    @Column(name="PASSWORD", nullable=false)
    protected String password;
    @Column(name="FIRST_NAME")
    protected String firstName;
    @Column(name="LAST_NAME")
    protected String lastName;
    @Column(name="EMAIL_ADDRESS")
    @Index(name="USER_EMAIL_INDEX", columnNames={"EMAIL_ADDRESS"})
    protected String emailAddress;
    @Column(name="CHALLENGE_QUESTION")
    protected String challengeQuestion;
    @Column(name="CHALLENGE_ANSWER")
    protected String challengeAnswer;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="user", targetEntity=UserRoleImpl.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    protected Set<UserRole> userRoles = new HashSet<UserRole>();
    @Column(name="PASSWORD_CHANGE_REQUIRED")
    protected boolean passwordChangeRequired;
    @Transient
    protected String unencodedPassword;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Set<UserRole> getUserRoles() {
        return this.userRoles;
    }

    @Override
    public void setUserRoles(Set<UserRole> userRoles) {
        this.userRoles = userRoles;
    }

    @Override
    public boolean isPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    @Override
    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public String getChallengeQuestion() {
        return this.challengeQuestion;
    }

    @Override
    public void setChallengeQuestion(String challengeQuestion) {
        this.challengeQuestion = challengeQuestion;
    }

    @Override
    public String getChallengeAnswer() {
        return this.challengeAnswer;
    }

    @Override
    public void setChallengeAnswer(String challengeAnswer) {
        this.challengeAnswer = challengeAnswer;
    }

    @Override
    public String getUnencodedPassword() {
        return this.unencodedPassword;
    }

    @Override
    public void setUnencodedPassword(String unencodedPassword) {
        this.unencodedPassword = unencodedPassword;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.userRoles == null ? 0 : ((Object)this.userRoles).hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserImpl other = (UserImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.userRoles == null ? other.userRoles != null : !((Object)this.userRoles).equals(other.userRoles)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

