/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.common.BroadleafEnumerationType;

public class CustomerAddressType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CustomerAddressType> TYPES = new HashMap<String, CustomerAddressType>();
    public static final CustomerAddressType SHIPPING = new CustomerAddressType("SHIPPING", "Shipping");
    public static final CustomerAddressType BILLING = new CustomerAddressType("BILLING", "Billing");
    public static final CustomerAddressType OTHER = new CustomerAddressType("OTHER", "Other");
    private String type;
    private String friendlyType;

    public static CustomerAddressType getInstance(String type) {
        return TYPES.get(type);
    }

    public CustomerAddressType() {
    }

    public CustomerAddressType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomerAddressType other = (CustomerAddressType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

