/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.common.presentation.AdminPresentation;
import org.broadleafcommerce.common.time.domain.TemporalTimestampListener;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CountryImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.domain.StateImpl;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Index;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_ADDRESS")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blOrderElements")
public class AddressImpl
implements Address {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="AddressId", strategy=GenerationType.TABLE)
    @TableGenerator(name="AddressId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="AddressImpl", allocationSize=50)
    @Column(name="ADDRESS_ID")
    protected Long id;
    @Column(name="ADDRESS_LINE1", nullable=false)
    @AdminPresentation(friendlyName="Address #1", order=6, group="Address")
    protected String addressLine1;
    @Column(name="ADDRESS_LINE2")
    @AdminPresentation(friendlyName="Address #2", order=7, group="Address")
    protected String addressLine2;
    @Column(name="CITY", nullable=false)
    @AdminPresentation(friendlyName="City", order=8, group="Address")
    protected String city;
    @Column(name="POSTAL_CODE", nullable=false)
    @AdminPresentation(friendlyName="Postal Code", order=14, group="Address")
    protected String postalCode;
    @Column(name="COUNTY")
    @AdminPresentation(friendlyName="County", order=11, group="Address")
    protected String county;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=StateImpl.class, optional=false)
    @JoinColumn(name="STATE_PROV_REGION")
    @Index(name="ADDRESS_STATE_INDEX", columnNames={"STATE_PROV_REGION"})
    @AdminPresentation(friendlyName="State", order=9, group="Address", excluded=true)
    protected State state;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CountryImpl.class, optional=false)
    @JoinColumn(name="COUNTRY")
    @Index(name="ADDRESS_COUNTRY_INDEX", columnNames={"COUNTRY"})
    @AdminPresentation(friendlyName="Country", order=12, group="Address", excluded=true)
    protected Country country;
    @Column(name="TOKENIZED_ADDRESS")
    @AdminPresentation(friendlyName="Tokenized Address", order=15, group="Address")
    protected String tokenizedAddress;
    @Column(name="STANDARDIZED")
    @AdminPresentation(friendlyName="Standardized", order=16, group="Address")
    protected Boolean standardized = Boolean.FALSE;
    @Column(name="ZIP_FOUR")
    @AdminPresentation(friendlyName="Four Digit Zip", order=17, group="Address")
    protected String zipFour;
    @Column(name="COMPANY_NAME")
    @AdminPresentation(friendlyName="Company Name", order=3, group="Address")
    protected String companyName;
    @Column(name="IS_DEFAULT")
    @AdminPresentation(friendlyName="Default Address", order=18, group="Address")
    protected boolean isDefault = false;
    @Column(name="IS_ACTIVE")
    @AdminPresentation(friendlyName="Active Address", order=19, group="Address")
    protected boolean isActive = true;
    @Column(name="FIRST_NAME")
    @AdminPresentation(friendlyName="First Name", order=1, group="Address")
    protected String firstName;
    @Column(name="LAST_NAME")
    @AdminPresentation(friendlyName="Last Name", order=2, group="Address")
    protected String lastName;
    @Column(name="PRIMARY_PHONE")
    @AdminPresentation(friendlyName="Primary Phone", order=4, group="Address")
    protected String primaryPhone;
    @Column(name="SECONDARY_PHONE")
    @AdminPresentation(friendlyName="Secondary Phone", order=5, group="Address")
    protected String secondaryPhone;
    @Column(name="IS_BUSINESS")
    @AdminPresentation(friendlyName="Business Address", order=20, group="Address")
    protected boolean isBusiness = false;
    @Column(name="VERIFICATION_LEVEL")
    @AdminPresentation(friendlyName="Verification Level", order=21, group="Address")
    protected String verificationLevel;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getAddressLine1() {
        return this.addressLine1;
    }

    @Override
    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    @Override
    public String getAddressLine2() {
        return this.addressLine2;
    }

    @Override
    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public void setCity(String city) {
        this.city = city;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.country = country;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @Override
    public String getCounty() {
        return this.county;
    }

    @Override
    public void setCounty(String county) {
        this.county = county;
    }

    @Override
    public State getState() {
        return this.state;
    }

    @Override
    public void setState(State state) {
        this.state = state;
    }

    @Override
    public String getTokenizedAddress() {
        return this.tokenizedAddress;
    }

    @Override
    public void setTokenizedAddress(String tokenizedAddress) {
        this.tokenizedAddress = tokenizedAddress;
    }

    @Override
    public Boolean getStandardized() {
        return this.standardized;
    }

    @Override
    public void setStandardized(Boolean standardized) {
        this.standardized = standardized;
    }

    @Override
    public String getZipFour() {
        return this.zipFour;
    }

    @Override
    public void setZipFour(String zipFour) {
        this.zipFour = zipFour;
    }

    @Override
    public String getCompanyName() {
        return this.companyName;
    }

    @Override
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getPrimaryPhone() {
        return this.primaryPhone;
    }

    @Override
    public void setPrimaryPhone(String primaryPhone) {
        this.primaryPhone = primaryPhone;
    }

    @Override
    public String getSecondaryPhone() {
        return this.secondaryPhone;
    }

    @Override
    public void setSecondaryPhone(String secondaryPhone) {
        this.secondaryPhone = secondaryPhone;
    }

    @Override
    public boolean isBusiness() {
        return this.isBusiness;
    }

    @Override
    public void setBusiness(boolean isBusiness) {
        this.isBusiness = isBusiness;
    }

    @Override
    public String getVerificationLevel() {
        return this.verificationLevel;
    }

    @Override
    public void setVerificationLevel(String verificationLevel) {
        this.verificationLevel = verificationLevel;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddressImpl other = (AddressImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.addressLine1 == null ? other.addressLine1 != null : !this.addressLine1.equals(other.addressLine1)) {
            return false;
        }
        if (this.addressLine2 == null ? other.addressLine2 != null : !this.addressLine2.equals(other.addressLine2)) {
            return false;
        }
        if (this.city == null ? other.city != null : !this.city.equals(other.city)) {
            return false;
        }
        if (this.companyName == null ? other.companyName != null : !this.companyName.equals(other.companyName)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        if (this.county == null ? other.county != null : !this.county.equals(other.county)) {
            return false;
        }
        if (this.firstName == null ? other.firstName != null : !this.firstName.equals(other.firstName)) {
            return false;
        }
        if (this.lastName == null ? other.lastName != null : !this.lastName.equals(other.lastName)) {
            return false;
        }
        if (this.postalCode == null ? other.postalCode != null : !this.postalCode.equals(other.postalCode)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.addressLine1 == null ? 0 : this.addressLine1.hashCode());
        result = 31 * result + (this.addressLine2 == null ? 0 : this.addressLine2.hashCode());
        result = 31 * result + (this.city == null ? 0 : this.city.hashCode());
        result = 31 * result + (this.companyName == null ? 0 : this.companyName.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.county == null ? 0 : this.county.hashCode());
        result = 31 * result + (this.firstName == null ? 0 : this.firstName.hashCode());
        result = 31 * result + (this.lastName == null ? 0 : this.lastName.hashCode());
        result = 31 * result + (this.postalCode == null ? 0 : this.postalCode.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }
}

