/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.vendor.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.profile.util.BroadleafEnumerationType;

public class ServiceStatusType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, ServiceStatusType> TYPES = new HashMap<String, ServiceStatusType>();
    public static final ServiceStatusType UP = new ServiceStatusType("UP", "Up");
    public static final ServiceStatusType DOWN = new ServiceStatusType("DOWN", "Down");
    public static final ServiceStatusType PAUSED = new ServiceStatusType("PAUSED", "Paused");
    private String type;
    private String friendlyType;

    public static ServiceStatusType getInstance(String type) {
        return TYPES.get(type);
    }

    public ServiceStatusType() {
    }

    public ServiceStatusType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    private void setType(String type) {
        this.type = type;
        if (TYPES.containsKey(type)) {
            throw new RuntimeException("Cannot add the type: (" + type + "). It already exists as a type via " + ServiceStatusType.getInstance(type).getClass().getName());
        }
        TYPES.put(type, this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServiceStatusType other = (ServiceStatusType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

