/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.util.dao;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchRetrieveDao {
    private int inClauseBatchSize = 300;

    public <T> List<T> batchExecuteReadQuery(Query query, List<?> params, String parameterName) {
        ArrayList response = new ArrayList();
        for (int start = 0; start < params.size(); start += this.inClauseBatchSize) {
            List<?> batchParams = params.subList(start, params.size() < this.inClauseBatchSize ? params.size() : this.inClauseBatchSize);
            query.setParameter(parameterName, batchParams);
            response.addAll(query.getResultList());
        }
        return response;
    }

    public int getInClauseBatchSize() {
        return this.inClauseBatchSize;
    }

    public void setInClauseBatchSize(int inClauseBatchSize) {
        this.inClauseBatchSize = inClauseBatchSize;
    }
}

