/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.jpa.convert.inheritance;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.extensibility.jpa.convert.BroadleafClassTransformer;
import org.broadleafcommerce.profile.extensibility.jpa.convert.inheritance.SingleTableInheritanceInfo;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleTableInheritanceClassTransformer
implements BroadleafClassTransformer {
    public static final String SINGLE_TABLE_ENTITIES = "broadleaf.ejb.entities.override_single_table";
    private static final Log LOG = LogFactory.getLog(SingleTableInheritanceClassTransformer.class);
    protected List<SingleTableInheritanceInfo> infos = new ArrayList<SingleTableInheritanceInfo>();

    @Override
    public void compileJPAProperties(Properties props, Object key) throws Exception {
        if (((String)key).equals(SINGLE_TABLE_ENTITIES)) {
            String[] classes;
            for (String clazz : classes = StringUtils.tokenizeToStringArray((String)props.getProperty((String)key), (String)",; \t\n")) {
                int pos = clazz.lastIndexOf(".");
                String keyName = pos >= 0 ? clazz.substring(pos + 1, clazz.length()) : clazz;
                SingleTableInheritanceInfo info = new SingleTableInheritanceInfo();
                info.setClassName(clazz);
                String discriminatorName = props.getProperty("broadleaf.ejb." + keyName + ".discriminator.name");
                if (discriminatorName != null) {
                    String length;
                    info.setDiscriminatorName(discriminatorName);
                    String type = props.getProperty("broadleaf.ejb." + keyName + ".discriminator.type");
                    if (type != null) {
                        info.setDiscriminatorType(DiscriminatorType.valueOf((String)type));
                    }
                    if ((length = props.getProperty("broadleaf.ejb." + keyName + ".discriminator.length")) != null) {
                        info.setDiscriminatorLength(Integer.parseInt(length));
                    }
                }
                this.infos.remove(info);
                this.infos.add(info);
            }
        }
    }

    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.infos.isEmpty()) {
            return classfileBuffer;
        }
        String convertedClassName = className.replace('/', '.');
        SingleTableInheritanceInfo key = new SingleTableInheritanceInfo();
        key.setClassName(convertedClassName);
        int pos = this.infos.indexOf(key);
        if (pos >= 0) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Converting " + convertedClassName + " to a SingleTable inheritance strategy."));
                }
                SingleTableInheritanceInfo myInfo = this.infos.get(pos);
                ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
                ConstPool constantPool = classFile.getConstPool();
                AnnotationsAttribute annotationsAttribute = new AnnotationsAttribute(constantPool, "RuntimeVisibleAnnotations");
                List attributes = classFile.getAttributes();
                Iterator itr = attributes.iterator();
                while (itr.hasNext()) {
                    Annotation[] items;
                    Object object = itr.next();
                    if (!AnnotationsAttribute.class.isAssignableFrom(object.getClass())) continue;
                    AnnotationsAttribute attr = (AnnotationsAttribute)object;
                    for (Annotation annotation : items = attr.getAnnotations()) {
                        String typeName = annotation.getTypeName();
                        if (typeName.equals(Inheritance.class.getName()) || (myInfo.getDiscriminatorName() != null || typeName.equals(Table.class.getName())) && myInfo.getDiscriminatorName() == null) continue;
                        annotationsAttribute.addAnnotation(annotation);
                    }
                    itr.remove();
                }
                Annotation inheritance = new Annotation(Inheritance.class.getName(), constantPool);
                ClassPool pool = ClassPool.getDefault();
                pool.importPackage("javax.persistence");
                pool.importPackage("java.lang");
                EnumMemberValue strategy = (EnumMemberValue)Annotation.createMemberValue((ConstPool)constantPool, (CtClass)pool.makeClass("InheritanceType"));
                strategy.setType(InheritanceType.class.getName());
                strategy.setValue(InheritanceType.SINGLE_TABLE.name());
                inheritance.addMemberValue("strategy", (MemberValue)strategy);
                annotationsAttribute.addAnnotation(inheritance);
                if (myInfo.getDiscriminatorName() != null) {
                    Annotation discriminator = new Annotation(DiscriminatorColumn.class.getName(), constantPool);
                    StringMemberValue name = new StringMemberValue(constantPool);
                    name.setValue(myInfo.getDiscriminatorName());
                    discriminator.addMemberValue("name", (MemberValue)name);
                    EnumMemberValue discriminatorType = (EnumMemberValue)Annotation.createMemberValue((ConstPool)constantPool, (CtClass)pool.makeClass("DiscriminatorType"));
                    discriminatorType.setType(DiscriminatorType.class.getName());
                    discriminatorType.setValue(myInfo.getDiscriminatorType().name());
                    discriminator.addMemberValue("discriminatorType", (MemberValue)discriminatorType);
                    IntegerMemberValue length = new IntegerMemberValue(constantPool);
                    length.setValue(myInfo.getDiscriminatorLength());
                    discriminator.addMemberValue("length", (MemberValue)length);
                    annotationsAttribute.addAnnotation(discriminator);
                }
                classFile.addAttribute((AttributeInfo)annotationsAttribute);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream os = new DataOutputStream(bos);
                classFile.write(os);
                os.close();
                return bos.toByteArray();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IllegalClassFormatException("Unable to convert " + convertedClassName + " to a SingleTable inheritance strategy: " + ex.getMessage());
            }
        }
        return classfileBuffer;
    }
}

