/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.extensibility.jpa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.extensibility.jpa.convert.BroadleafClassTransformer;
import org.springframework.orm.jpa.persistenceunit.DefaultPersistenceUnitManager;
import org.springframework.orm.jpa.persistenceunit.Jpa2PersistenceUnitInfoDecorator;
import org.springframework.orm.jpa.persistenceunit.MutablePersistenceUnitInfo;
import org.springframework.orm.jpa.persistenceunit.SmartPersistenceUnitInfo;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergePersistenceUnitManager
extends DefaultPersistenceUnitManager {
    private static final Log LOG = LogFactory.getLog(MergePersistenceUnitManager.class);
    protected HashMap<String, PersistenceUnitInfo> mergedPus = new HashMap();
    protected final boolean jpa2ApiPresent = ClassUtils.hasMethod(PersistenceUnitInfo.class, (String)"getSharedCacheMode", (Class[])new Class[0]);
    protected List<BroadleafClassTransformer> classTransformers = new ArrayList<BroadleafClassTransformer>();

    protected PersistenceUnitInfo getMergedUnit(String persistenceUnitName, MutablePersistenceUnitInfo newPU) {
        if (!this.mergedPus.containsKey(persistenceUnitName)) {
            MutablePersistenceUnitInfo puiToStore = newPU;
            if (this.jpa2ApiPresent) {
                puiToStore = (PersistenceUnitInfo)Proxy.newProxyInstance(SmartPersistenceUnitInfo.class.getClassLoader(), new Class[]{SmartPersistenceUnitInfo.class}, (InvocationHandler)new Jpa2PersistenceUnitInfoDecorator((PersistenceUnitInfo)newPU));
            }
            for (BroadleafClassTransformer transformer : this.classTransformers) {
                try {
                    puiToStore.addTransformer((ClassTransformer)transformer);
                }
                catch (IllegalStateException e) {
                    LOG.warn((Object)("A BroadleafClassTransformer is configured for this persistence unit, but Spring reported a problem (likely that a LoadTimeWeaver is not registered). As a result, the Broadleaf Commerce ClassTransformer (" + transformer.getClass().getName() + ") is not being registered with the persistence unit."), (Throwable)e);
                }
            }
            this.mergedPus.put(persistenceUnitName, (PersistenceUnitInfo)puiToStore);
        }
        return this.mergedPus.get(persistenceUnitName);
    }

    protected void postProcessPersistenceUnitInfo(MutablePersistenceUnitInfo newPU) {
        MutablePersistenceUnitInfo temp;
        super.postProcessPersistenceUnitInfo(newPU);
        newPU.addJarFileUrl(newPU.getPersistenceUnitRootUrl());
        String persistenceUnitName = newPU.getPersistenceUnitName();
        PersistenceUnitInfo pui = this.getMergedUnit(persistenceUnitName, newPU);
        if (pui != null && Proxy.isProxyClass(pui.getClass())) {
            Jpa2PersistenceUnitInfoDecorator dec = (Jpa2PersistenceUnitInfoDecorator)Proxy.getInvocationHandler(pui);
            temp = (MutablePersistenceUnitInfo)dec.getTarget();
        } else {
            temp = (MutablePersistenceUnitInfo)pui;
        }
        temp.setPersistenceUnitRootUrl(null);
        List managedClassNames = newPU.getManagedClassNames();
        for (String managedClassName : managedClassNames) {
            if (temp.getManagedClassNames().contains(managedClassName)) continue;
            temp.addManagedClassName(managedClassName);
        }
        List mappingFileNames = newPU.getMappingFileNames();
        for (String mappingFileName : mappingFileNames) {
            if (temp.getMappingFileNames().contains(mappingFileName)) continue;
            temp.addMappingFileName(mappingFileName);
        }
        temp.setExcludeUnlistedClasses(newPU.excludeUnlistedClasses());
        for (URL url : newPU.getJarFileUrls()) {
            if (temp.getJarFileUrls().contains(url)) continue;
            temp.addJarFileUrl(url);
        }
        temp.setJtaDataSource(newPU.getJtaDataSource());
        temp.setNonJtaDataSource(newPU.getNonJtaDataSource());
        if (temp.getProperties() == null) {
            temp.setProperties(newPU.getProperties());
        } else {
            Properties props = newPU.getProperties();
            if (props != null) {
                for (Object key : props.keySet()) {
                    temp.getProperties().setProperty((String)key, props.getProperty((String)key));
                    for (BroadleafClassTransformer transformer : this.classTransformers) {
                        try {
                            transformer.compileJPAProperties(props, key);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
        temp.setTransactionType(newPU.getTransactionType());
        if (newPU.getPersistenceProviderClassName() != null) {
            temp.setPersistenceProviderClassName(newPU.getPersistenceProviderClassName());
        }
        if (newPU.getPersistenceProviderPackageName() != null) {
            temp.setPersistenceProviderPackageName(newPU.getPersistenceProviderPackageName());
        }
    }

    public PersistenceUnitInfo obtainPersistenceUnitInfo(String persistenceUnitName) {
        return this.mergedPus.get(persistenceUnitName);
    }

    public PersistenceUnitInfo obtainDefaultPersistenceUnitInfo() {
        throw new IllegalStateException("Default Persistence Unit is not supported. The persistence unit name must be specified at the entity manager factory.");
    }

    public List<BroadleafClassTransformer> getClassTransformers() {
        return this.classTransformers;
    }

    public void setClassTransformers(List<BroadleafClassTransformer> classTransformers) {
        this.classTransformers = classTransformers;
    }
}

