/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.email.domain;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.profile.email.domain.EmailTracking;
import org.broadleafcommerce.profile.email.domain.EmailTrackingImpl;
import org.broadleafcommerce.profile.email.domain.EmailTrackingOpens;
import org.hibernate.annotations.Index;

@Entity
@Table(name="BLC_EMAIL_TRACKING_OPENS")
public class EmailTrackingOpensImpl
implements EmailTrackingOpens {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="OpenId", strategy=GenerationType.TABLE)
    @TableGenerator(name="OpenId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="EmailTrackingOpensImpl", allocationSize=50)
    @Column(name="OPEN_ID")
    protected Long id;
    @Column(name="DATE_OPENED")
    protected Date dateOpened;
    @Column(name="USER_AGENT")
    protected String userAgent;
    @ManyToOne(targetEntity=EmailTrackingImpl.class)
    @JoinColumn(name="EMAIL_TRACKING_ID")
    @Index(name="TRACKINGOPEN_TRACKING", columnNames={"EMAIL_TRACKING_ID"})
    protected EmailTracking emailTracking;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getDateOpened() {
        return this.dateOpened;
    }

    public void setDateOpened(Date dateOpened) {
        this.dateOpened = dateOpened;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        if (userAgent.length() > 255) {
            userAgent = userAgent.substring(0, 254);
        }
        this.userAgent = userAgent;
    }

    public EmailTracking getEmailTracking() {
        return this.emailTracking;
    }

    public void setEmailTracking(EmailTracking emailTracking) {
        this.emailTracking = emailTracking;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dateOpened == null ? 0 : this.dateOpened.hashCode());
        result = 31 * result + (this.emailTracking == null ? 0 : this.emailTracking.hashCode());
        result = 31 * result + (this.userAgent == null ? 0 : this.userAgent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmailTrackingOpensImpl other = (EmailTrackingOpensImpl)obj;
        if (this.id == null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.dateOpened == null ? other.dateOpened != null : !this.dateOpened.equals(other.dateOpened)) {
            return false;
        }
        if (this.emailTracking == null ? other.emailTracking != null : !this.emailTracking.equals(other.emailTracking)) {
            return false;
        }
        return !(this.userAgent == null ? other.userAgent != null : !this.userAgent.equals(other.userAgent));
    }
}

