/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.email.dao;

import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.broadleafcommerce.config.EntityConfiguration;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.email.dao.EmailReportingDao;
import org.broadleafcommerce.profile.email.domain.EmailTarget;
import org.broadleafcommerce.profile.email.domain.EmailTracking;
import org.broadleafcommerce.profile.email.domain.EmailTrackingClicks;
import org.broadleafcommerce.profile.email.domain.EmailTrackingOpens;
import org.broadleafcommerce.profile.time.SystemTime;
import org.springframework.stereotype.Repository;

@Repository(value="blEmailReportingDao")
public class EmailReportingDaoImpl
implements EmailReportingDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    public Long createTracking(String emailAddress, String type, String extraValue) {
        EmailTracking tracking = (EmailTracking)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTracking");
        tracking.setDateSent(SystemTime.asDate());
        tracking.setEmailAddress(emailAddress);
        tracking.setType(type);
        this.em.persist((Object)tracking);
        return tracking.getId();
    }

    public EmailTarget createTarget() {
        EmailTarget target = (EmailTarget)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTarget");
        return target;
    }

    public EmailTracking retrieveTracking(Long emailId) {
        return (EmailTracking)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.email.domain.EmailTracking"), (Object)emailId);
    }

    public void recordOpen(Long emailId, String userAgent) {
        EmailTrackingOpens opens = (EmailTrackingOpens)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTrackingOpens");
        opens.setEmailTracking(this.retrieveTracking(emailId));
        opens.setDateOpened(SystemTime.asDate());
        opens.setUserAgent(userAgent);
        this.em.persist((Object)opens);
    }

    public void recordClick(Long emailId, Customer customer, String destinationUri, String queryString) {
        EmailTrackingClicks clicks = (EmailTrackingClicks)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.email.domain.EmailTrackingClicks");
        clicks.setEmailTracking(this.retrieveTracking(emailId));
        clicks.setDateClicked(SystemTime.asDate());
        clicks.setDestinationUri(destinationUri);
        clicks.setQueryString(queryString);
        clicks.setCustomer(customer);
        this.em.persist((Object)clicks);
    }
}

