/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.core.dao.CustomerPhoneDao;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.service.CustomerPhoneService;
import org.springframework.stereotype.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(value="blCustomerPhoneService")
public class CustomerPhoneServiceImpl
implements CustomerPhoneService {
    @Resource(name="blCustomerPhoneDao")
    protected CustomerPhoneDao customerPhoneDao;

    @Override
    public CustomerPhone saveCustomerPhone(CustomerPhone customerPhone) {
        List<CustomerPhone> activeCustomerPhones = this.readActiveCustomerPhonesByCustomerId(customerPhone.getCustomer().getId());
        if (activeCustomerPhones != null && activeCustomerPhones.isEmpty()) {
            customerPhone.getPhone().setDefault(true);
        } else if (customerPhone.getPhone().isDefault()) {
            for (CustomerPhone activeCustomerPhone : activeCustomerPhones) {
                if (activeCustomerPhone.getId() == customerPhone.getId() || !activeCustomerPhone.getPhone().isDefault()) continue;
                activeCustomerPhone.getPhone().setDefault(false);
                this.customerPhoneDao.save(activeCustomerPhone);
            }
        }
        return this.customerPhoneDao.save(customerPhone);
    }

    @Override
    public List<CustomerPhone> readActiveCustomerPhonesByCustomerId(Long customerId) {
        return this.customerPhoneDao.readActiveCustomerPhonesByCustomerId(customerId);
    }

    @Override
    public CustomerPhone readCustomerPhoneById(Long customerPhoneId) {
        return this.customerPhoneDao.readCustomerPhoneById(customerPhoneId);
    }

    @Override
    public void makeCustomerPhoneDefault(Long customerPhoneId, Long customerId) {
        this.customerPhoneDao.makeCustomerPhoneDefault(customerPhoneId, customerId);
    }

    @Override
    public void deleteCustomerPhoneById(Long customerPhoneId) {
        this.customerPhoneDao.deleteCustomerPhoneById(customerPhoneId);
    }

    @Override
    public CustomerPhone findDefaultCustomerPhone(Long customerId) {
        return this.customerPhoneDao.findDefaultCustomerPhone(customerId);
    }

    @Override
    public List<CustomerPhone> readAllCustomerPhonesByCustomerId(Long customerId) {
        return this.customerPhoneDao.readAllCustomerPhonesByCustomerId(customerId);
    }

    @Override
    public CustomerPhone create() {
        return this.customerPhoneDao.create();
    }
}

