/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerImpl;
import org.broadleafcommerce.profile.core.domain.CustomerPhone;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.hibernate.annotations.Index;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER_PHONE", uniqueConstraints={@UniqueConstraint(columnNames={"CUSTOMER_ID", "PHONE_NAME"})})
public class CustomerPhoneImpl
implements CustomerPhone {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CustomerPhoneId", strategy=GenerationType.TABLE)
    @TableGenerator(name="CustomerPhoneId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="CustomerPhoneImpl", allocationSize=50)
    @Column(name="CUSTOMER_PHONE_ID")
    protected Long id;
    @Column(name="PHONE_NAME")
    protected String phoneName;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    protected Customer customer;
    @ManyToOne(cascade={CascadeType.ALL}, targetEntity=PhoneImpl.class, optional=false)
    @JoinColumn(name="PHONE_ID")
    @Index(name="CUSTPHONE_PHONE_INDEX", columnNames={"PHONE_ID"})
    protected Phone phone;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPhoneName() {
        return this.phoneName;
    }

    public void setPhoneName(String phoneName) {
        this.phoneName = phoneName;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Phone getPhone() {
        return this.phone;
    }

    public void setPhone(Phone phone) {
        this.phone = phone;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        result = 31 * result + (this.phone == null ? 0 : this.phone.hashCode());
        result = 31 * result + (this.phoneName == null ? 0 : this.phoneName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomerPhoneImpl other = (CustomerPhoneImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        if (this.phone == null ? other.phone != null : !this.phone.equals(other.phone)) {
            return false;
        }
        return !(this.phoneName == null ? other.phoneName != null : !this.phoneName.equals(other.phoneName));
    }
}

