/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.config.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.RoleDao;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.CustomerRole;
import org.broadleafcommerce.profile.core.domain.Role;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="blRoleDao")
public class RoleDaoImpl
implements RoleDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    public Address readAddressById(Long id) {
        return (Address)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.core.domain.Address"), (Object)id);
    }

    @Override
    public List<CustomerRole> readCustomerRolesByCustomerId(Long customerId) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_ROLES_BY_CUSTOMER_ID");
        query.setParameter("customerId", (Object)customerId);
        return query.getResultList();
    }

    @Override
    public Role readRoleByName(String name) {
        Query query = this.em.createNamedQuery("BC_READ_ROLE_BY_NAME");
        query.setParameter("name", (Object)name);
        return (Role)query.getSingleResult();
    }

    @Override
    public void addRoleToCustomer(CustomerRole customerRole) {
        this.em.persist((Object)customerRole);
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }
}

