/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.core.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.config.EntityConfiguration;
import org.broadleafcommerce.profile.core.dao.CountryDao;
import org.broadleafcommerce.profile.core.domain.Country;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository(value="blCountryDao")
public class CountryDaoImpl
implements CountryDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public Country findCountryByAbbreviation(String abbreviation) {
        return (Country)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.core.domain.Country"), (Object)abbreviation);
    }

    @Override
    public List<Country> findCountries() {
        Query query = this.em.createNamedQuery("BC_FIND_COUNTRIES");
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }

    @Override
    public Country save(Country country) {
        return (Country)this.em.merge((Object)country);
    }
}

