/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.cache;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Id;
import org.broadleafcommerce.profile.cache.Hydrated;
import org.broadleafcommerce.profile.cache.HydrationItemDescriptor;
import org.hibernate.annotations.Cache;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HydrationScanner
implements ClassVisitor,
FieldVisitor,
AnnotationVisitor {
    private static final int CLASSSTAGE = 0;
    private static final int FIELDSTAGE = 1;
    private String cacheRegion;
    private Map<String, Method[]> idMutators = new HashMap<String, Method[]>();
    private Map<String, HydrationItemDescriptor> cacheMutators = new HashMap<String, HydrationItemDescriptor>();
    private final Class entityClass;
    private final Class topEntityClass;
    private int stage = 0;
    private Class clazz;
    private String annotation;
    private String fieldName;
    private Class fieldClass;

    public HydrationScanner(Class topEntityClass, Class entityClass) {
        this.topEntityClass = topEntityClass;
        this.entityClass = entityClass;
    }

    public void init() {
        try {
            InputStream in = HydrationScanner.class.getClassLoader().getResourceAsStream(this.topEntityClass.getName().replace('.', '/') + ".class");
            new ClassReader(in).accept((ClassVisitor)this, true);
            in = HydrationScanner.class.getClassLoader().getResourceAsStream(this.entityClass.getName().replace('.', '/') + ".class");
            new ClassReader(in).accept((ClassVisitor)this, true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCacheRegion() {
        return this.cacheRegion;
    }

    public Map<String, Method[]> getIdMutators() {
        return this.idMutators;
    }

    public Map<String, HydrationItemDescriptor> getCacheMutators() {
        return this.cacheMutators;
    }

    public AnnotationVisitor visitAnnotation(String arg0, boolean arg1) {
        Type annotationType = Type.getType((String)arg0);
        switch (this.stage) {
            case 0: {
                if (!annotationType.getClassName().equals(Cache.class.getName())) break;
                this.annotation = Cache.class.getName();
                break;
            }
            case 1: {
                if (annotationType.getClassName().equals(Id.class.getName())) {
                    this.idMutators.put(this.fieldName, this.retrieveMutators());
                }
                if (!annotationType.getClassName().equals(Hydrated.class.getName())) break;
                this.annotation = Hydrated.class.getName();
                break;
            }
            default: {
                this.annotation = null;
                this.fieldName = null;
            }
        }
        return this;
    }

    private Method[] retrieveMutators() {
        String mutatorName = this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1, this.fieldName.length());
        Method getMethod = null;
        try {
            getMethod = this.clazz.getMethod("get" + mutatorName, new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (getMethod == null) {
            try {
                getMethod = this.clazz.getMethod("is" + mutatorName, new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (getMethod == null) {
            try {
                getMethod = this.clazz.getMethod(this.fieldName, new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Method setMethod = null;
        try {
            setMethod = this.clazz.getMethod("set" + mutatorName, this.fieldClass);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (getMethod == null || setMethod == null) {
            throw new RuntimeException("Unable to find a getter and setter method for the AdminPresentation field: " + this.fieldName + ". Make sure you have a getter method entitled: get" + mutatorName + "(), or is" + mutatorName + "(), or " + this.fieldName + "(). Make sure you have a setter method entitled: set" + mutatorName + "(..).");
        }
        return new Method[]{getMethod, setMethod};
    }

    public void visitAttribute(Attribute arg0) {
    }

    public void visitEnd() {
    }

    public void visit(int arg0, int arg1, String arg2, String arg3, String arg4, String[] arg5) {
        try {
            this.clazz = Class.forName(arg2.replaceAll("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.stage = 0;
    }

    public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
        this.stage = 1;
        this.fieldName = arg1;
        Type fieldType = Type.getType((String)arg2);
        switch (fieldType.getSort()) {
            case 1: {
                this.fieldClass = Boolean.TYPE;
                break;
            }
            case 3: {
                this.fieldClass = Byte.TYPE;
                break;
            }
            case 2: {
                this.fieldClass = Character.TYPE;
                break;
            }
            case 8: {
                this.fieldClass = Double.TYPE;
                break;
            }
            case 6: {
                this.fieldClass = Float.TYPE;
                break;
            }
            case 5: {
                this.fieldClass = Integer.TYPE;
                break;
            }
            case 7: {
                this.fieldClass = Long.TYPE;
                break;
            }
            case 4: {
                this.fieldClass = Short.TYPE;
                break;
            }
            case 10: {
                try {
                    this.fieldClass = Class.forName(Type.getType((String)arg2).getClassName());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this;
    }

    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        return new EmptyVisitor();
    }

    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    public void visitSource(String arg0, String arg1) {
    }

    public void visit(String arg0, Object arg1) {
        if (Cache.class.getName().equals(this.annotation) && "region".equals(arg0)) {
            this.cacheRegion = (String)arg1;
        }
        if (Hydrated.class.getName().equals(this.annotation) && "factoryMethod".equals(arg0)) {
            HydrationItemDescriptor itemDescriptor = new HydrationItemDescriptor();
            itemDescriptor.setFactoryMethod((String)arg1);
            itemDescriptor.setMutators(this.retrieveMutators());
            this.cacheMutators.put(this.fieldName, itemDescriptor);
        }
    }

    public AnnotationVisitor visitAnnotation(String arg0, String arg1) {
        return this;
    }

    public AnnotationVisitor visitArray(String arg0) {
        return this;
    }

    public void visitEnum(String arg0, String arg1, String arg2) {
    }
}

