/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.cache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.CacheEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.cache.HydratedAnnotationManager;
import org.broadleafcommerce.profile.cache.HydratedCache;
import org.broadleafcommerce.profile.cache.HydratedCacheElement;
import org.broadleafcommerce.profile.cache.HydratedCacheManager;
import org.broadleafcommerce.profile.cache.HydrationDescriptor;
import org.broadleafcommerce.profile.cache.HydrationScanner;
import org.hibernate.cache.CacheKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HydratedCacheManagerImpl
implements CacheEventListener,
HydratedCacheManager,
HydratedAnnotationManager {
    private static final Log LOG = LogFactory.getLog(HydratedCacheManagerImpl.class);
    private static final HydratedCacheManagerImpl MANAGER = new HydratedCacheManagerImpl();
    private Map<String, HydratedCache> hydratedCacheContainer = new Hashtable<String, HydratedCache>();
    private Map<String, HydrationDescriptor> hydrationDescriptors = new Hashtable<String, HydrationDescriptor>();

    public static HydratedCacheManagerImpl getInstance() {
        return MANAGER;
    }

    private HydratedCacheManagerImpl() {
    }

    public void addHydratedCache(HydratedCache cache) {
        this.hydratedCacheContainer.put(cache.getCacheName(), cache);
    }

    public HydratedCache removeHydratedCache(String cacheName) {
        return this.hydratedCacheContainer.remove(cacheName);
    }

    public HydratedCache getHydratedCache(String cacheName) {
        if (!this.containsCache(cacheName)) {
            HydratedCache cache = new HydratedCache(cacheName);
            this.addHydratedCache(cache);
        }
        return this.hydratedCacheContainer.get(cacheName);
    }

    public boolean containsCache(String cacheName) {
        return this.hydratedCacheContainer.containsKey(cacheName);
    }

    @Override
    public HydrationDescriptor getHydrationDescriptor(Object entity) {
        if (this.hydrationDescriptors.containsKey(entity.getClass().getName())) {
            return this.hydrationDescriptors.get(entity.getClass().getName());
        }
        HydrationDescriptor descriptor = new HydrationDescriptor();
        Class<?> topEntityClass = this.getTopEntityClass(entity);
        HydrationScanner scanner = new HydrationScanner(topEntityClass, entity.getClass());
        scanner.init();
        descriptor.setHydratedMutators(scanner.getCacheMutators());
        Map<String, Method[]> mutators = scanner.getIdMutators();
        if (mutators.size() != 1) {
            throw new RuntimeException("Broadleaf Commerce Hydrated Cache currently only supports entities with a single @Id annotation.");
        }
        Method[] singleMutators = mutators.values().iterator().next();
        descriptor.setIdMutators(singleMutators);
        String cacheRegion = scanner.getCacheRegion();
        if (cacheRegion == null || "".equals(cacheRegion)) {
            cacheRegion = topEntityClass.getName();
        }
        descriptor.setCacheRegion(cacheRegion);
        this.hydrationDescriptors.put(entity.getClass().getName(), descriptor);
        return descriptor;
    }

    public Class<?> getTopEntityClass(Object entity) {
        Class<?> myClass = entity.getClass();
        for (Class<?> superClass = entity.getClass().getSuperclass(); superClass != null && superClass.getName().startsWith("org.broadleaf"); superClass = superClass.getSuperclass()) {
            myClass = superClass;
        }
        return myClass;
    }

    @Override
    public Object getHydratedCacheElementItem(String cacheName, Serializable elementKey, String elementItemName) {
        Object response = null;
        HydratedCache hydratedCache = this.getHydratedCache(cacheName);
        HydratedCacheElement element = hydratedCache.getCacheElement(cacheName, elementKey);
        if (element != null) {
            response = element.getCacheElementItem(elementItemName, elementKey);
        }
        return response;
    }

    @Override
    public void addHydratedCacheElementItem(String cacheName, Serializable elementKey, String elementItemName, Object elementValue) {
        HydratedCache hydratedCache = this.getHydratedCache(cacheName);
        HydratedCacheElement element = hydratedCache.getCacheElement(cacheName, elementKey);
        if (element == null) {
            element = new HydratedCacheElement();
            hydratedCache.addCacheElement(cacheName, elementKey, element);
        }
        element.putCacheElementItem(elementItemName, elementKey, elementValue);
    }

    public void dispose() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Disposing of all hydrated cache members");
        }
        this.hydratedCacheContainer.clear();
    }

    private void removeCache(String cacheName, Serializable key) {
        String myKey;
        HydratedCache cache;
        if (key instanceof CacheKey) {
            key = ((CacheKey)key).getKey();
        }
        if (this.hydratedCacheContainer.containsKey(cacheName) && (cache = this.hydratedCacheContainer.get(cacheName)).containsKey(myKey = cacheName + "_" + key)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Clearing hydrated cache for cache name: " + cacheName + "_" + key));
            }
            cache.removeCacheElement(cacheName, key);
        }
    }

    private void removeAll(String cacheName) {
        if (this.hydratedCacheContainer.containsKey(cacheName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Clearing all hydrated caches for cache name: " + cacheName));
            }
            this.hydratedCacheContainer.remove(cacheName);
        }
    }

    public void notifyElementEvicted(Ehcache arg0, Element arg1) {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementExpired(Ehcache arg0, Element arg1) {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementPut(Ehcache arg0, Element arg1) throws CacheException {
    }

    public void notifyElementRemoved(Ehcache arg0, Element arg1) throws CacheException {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyElementUpdated(Ehcache arg0, Element arg1) throws CacheException {
        this.removeCache(arg0.getName(), arg1.getKey());
    }

    public void notifyRemoveAll(Ehcache arg0) {
        this.removeAll(arg0.getName());
    }

    public Object clone() throws CloneNotSupportedException {
        return this;
    }
}

