/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.util.money;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Locale;
import org.broadleafcommerce.util.money.BankersRounding;

public final class Money
implements Serializable,
Cloneable,
Comparable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private BigDecimal amount;
    private final Currency currency;

    public Money() {
        this(BankersRounding.zeroAmount(), Money.defaultCurrency());
    }

    public Money(BigDecimal amount) {
        this(amount, Money.defaultCurrency());
    }

    public Money(double amount) {
        this(Money.valueOf(amount), Money.defaultCurrency());
    }

    public Money(int amount) {
        this(BigDecimal.valueOf(amount), Money.defaultCurrency());
    }

    public Money(long amount) {
        this(BigDecimal.valueOf(amount), Money.defaultCurrency());
    }

    public Money(String amount) {
        this(new BigDecimal(amount), Money.defaultCurrency());
    }

    public Money(BigDecimal amount, String currencyCode) {
        this(amount, Currency.getInstance(currencyCode));
    }

    public Money(double amount, Currency currency) {
        this(Money.valueOf(amount), currency);
    }

    public Money(double amount, String currencyCode) {
        this(Money.valueOf(amount), Currency.getInstance(currencyCode));
    }

    public Money(int amount, Currency currency) {
        this(BigDecimal.valueOf(amount), currency);
    }

    public Money(int amount, String currencyCode) {
        this(BigDecimal.valueOf(amount), Currency.getInstance(currencyCode));
    }

    public Money(long amount, Currency currency) {
        this(BigDecimal.valueOf(amount), currency);
    }

    public Money(long amount, String currencyCode) {
        this(BigDecimal.valueOf(amount), Currency.getInstance(currencyCode));
    }

    public Money(String amount, Currency currency) {
        this(new BigDecimal(amount), currency);
    }

    public Money(String amount, String currencyCode) {
        this(new BigDecimal(amount), Currency.getInstance(currencyCode));
    }

    public Money(BigDecimal amount, Currency currency) {
        if (currency == null) {
            throw new IllegalArgumentException("currency cannot be null");
        }
        this.currency = currency;
        this.amount = BankersRounding.setScale(amount);
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public Money add(Money other) {
        return new Money(this.amount.add(other.amount), this.currency);
    }

    public Money subtract(Money other) {
        return new Money(this.amount.subtract(other.amount), this.currency);
    }

    public Money multiply(double amount) {
        return this.multiply(Money.valueOf(amount));
    }

    public Money multiply(int amount) {
        return this.multiply(BigDecimal.valueOf(amount));
    }

    public Money multiply(BigDecimal multiplier) {
        return new Money(this.amount.multiply(multiplier), this.currency);
    }

    public Money divide(double amount) {
        return this.divide(Money.valueOf(amount));
    }

    public Money divide(int amount) {
        return this.divide(BigDecimal.valueOf(amount));
    }

    public Money divide(BigDecimal divisor) {
        return new Money(BankersRounding.divide(this.amount, divisor), this.currency);
    }

    public Money abs() {
        return new Money(this.amount.abs(), this.currency);
    }

    public Money min(Money other) {
        if (other == null) {
            return this;
        }
        return this.lessThan(other) ? this : other;
    }

    public Money max(Money other) {
        if (other == null) {
            return this;
        }
        return this.greaterThan(other) ? this : other;
    }

    public Money negate() {
        return new Money(this.amount.negate(), this.currency);
    }

    public boolean isZero() {
        return this.amount.compareTo(BankersRounding.zeroAmount()) == 0;
    }

    public Money zero() {
        return Money.zero(this.currency);
    }

    public boolean lessThan(Money other) {
        return this.compareTo(other) < 0;
    }

    public boolean lessThan(BigDecimal value) {
        return this.amount.compareTo(value) < 0;
    }

    public boolean lessThanOrEqual(Money other) {
        return this.compareTo(other) <= 0;
    }

    public boolean lessThanOrEqual(BigDecimal value) {
        return this.amount.compareTo(value) <= 0;
    }

    public boolean greaterThan(Money other) {
        return this.compareTo(other) > 0;
    }

    public boolean greaterThan(BigDecimal value) {
        return this.amount.compareTo(value) > 0;
    }

    public boolean greaterThanOrEqual(Money other) {
        return this.compareTo(other) >= 0;
    }

    public boolean greaterThanOrEqual(BigDecimal value) {
        return this.amount.compareTo(value) >= 0;
    }

    public int compareTo(Money other) {
        return this.amount.compareTo(other.amount);
    }

    public int compareTo(BigDecimal value) {
        return this.amount.compareTo(value);
    }

    public int compareTo(Object other) {
        Money otherMoney = (Money)other;
        return this.compareTo(otherMoney);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Money)) {
            return false;
        }
        Money money = (Money)o;
        if (this.amount != null ? !this.amount.equals(money.amount) : money.amount != null) {
            return false;
        }
        return !(this.currency != null ? !this.currency.equals(money.currency) : money.currency != null);
    }

    public int hashCode() {
        int result = this.amount != null ? this.amount.hashCode() : 0;
        result = 31 * result + (this.currency != null ? this.currency.hashCode() : 0);
        return result;
    }

    public Object clone() {
        return new Money(this.amount, this.currency);
    }

    public String toString() {
        return this.amount.toString();
    }

    public double doubleValue() {
        try {
            return this.amount.doubleValue();
        }
        catch (NumberFormatException e) {
            if (e.getMessage().equals("For input string: \"0.00null\"")) {
                return this.amount.doubleValue();
            }
            throw e;
        }
    }

    public String stringValue() {
        return this.amount.toString() + " " + this.currency.getCurrencyCode();
    }

    public static Money zero(String currencyCode) {
        return Money.zero(Currency.getInstance(currencyCode));
    }

    public static Money zero(Currency currency) {
        return new Money(BankersRounding.zeroAmount(), currency);
    }

    public static Money abs(Money money) {
        return new Money(money.amount.abs(), money.currency);
    }

    public static Money min(Money left, Money right) {
        return left.min(right);
    }

    public static Money max(Money left, Money right) {
        return left.max(right);
    }

    public static BigDecimal toAmount(Money money) {
        return money == null ? null : money.amount;
    }

    public static Currency toCurrency(Money money) {
        return money == null ? null : money.currency;
    }

    private static BigDecimal valueOf(double amount) {
        return new BigDecimal(String.valueOf(amount));
    }

    private static Currency defaultCurrency() {
        Locale locale = Locale.getDefault();
        if (locale.getCountry() != null && locale.getCountry().length() == 2) {
            return Currency.getInstance(locale);
        }
        return Currency.getInstance(System.getProperty("currency.default", "USD"));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.amount = new BigDecimal(in.readFloat());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeFloat(this.amount.floatValue());
    }
}

