/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.util;

public class StatCalc {
    private int count;
    private double sum;
    private double squareSum;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;

    public void enter(double num) {
        ++this.count;
        this.sum += num;
        this.squareSum += num * num;
        if (num > this.max) {
            this.max = num;
        }
        if (num < this.min) {
            this.min = num;
        }
    }

    public int getCount() {
        return this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getStandardDeviation() {
        double mean = this.getMean();
        return Math.sqrt(this.squareSum / (double)this.count - mean * mean);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }
}

