/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.util;

import java.util.Properties;
import net.sf.ehcache.event.CacheManagerEventListener;
import net.sf.ehcache.event.CacheManagerEventListenerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.util.HydratedCache;
import org.broadleafcommerce.util.HydratedCacheManager;

public class HydratedCacheManagerEventListenerFactory
extends CacheManagerEventListenerFactory {
    private static final Log LOG = LogFactory.getLog(HydratedCacheManagerEventListenerFactory.class);

    public CacheManagerEventListener createCacheManagerEventListener(Properties props) {
        String[] names;
        String cacheNames = props.getProperty("cacheNames");
        if (cacheNames == null) {
            throw new RuntimeException("Must specify a cacheNames property with a semi-colon delimitted list of cache names.");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("adding hydrated cache objects for registered cache names: " + cacheNames));
        }
        for (String name : names = cacheNames.split(";")) {
            HydratedCache cache = new HydratedCache(name);
            HydratedCacheManager.getInstance().addHydratedCache(cache);
        }
        return HydratedCacheManager.getInstance();
    }
}

