/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.util;

import java.util.Hashtable;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Status;
import net.sf.ehcache.event.CacheManagerEventListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.util.HydratedCache;

public class HydratedCacheManager
implements CacheManagerEventListener {
    private static final Log LOG = LogFactory.getLog(HydratedCacheManager.class);
    private static HydratedCacheManager manager = null;
    private final Hashtable<String, HydratedCache> hydratedCacheManager = new Hashtable();

    public static synchronized HydratedCacheManager getInstance() {
        if (manager == null) {
            manager = new HydratedCacheManager();
        }
        return manager;
    }

    private HydratedCacheManager() {
    }

    public void addHydratedCache(HydratedCache cache) {
        this.hydratedCacheManager.put(cache.getCacheName(), cache);
    }

    public HydratedCache removeHydratedCache(String cacheName) {
        return this.hydratedCacheManager.remove(cacheName);
    }

    public HydratedCache getHydratedCache(String cacheName) {
        return this.hydratedCacheManager.get(cacheName);
    }

    public void dispose() throws CacheException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Disposing of all hydrated cache members");
        }
        this.hydratedCacheManager.clear();
    }

    public Status getStatus() {
        return Status.STATUS_ALIVE;
    }

    public void init() throws CacheException {
    }

    public void notifyCacheAdded(String cacheName) {
    }

    public synchronized void notifyCacheRemoved(String cacheName) {
        if (this.hydratedCacheManager.containsKey(cacheName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Clearing hydrated cache for cache name: " + cacheName));
            }
            this.hydratedCacheManager.get(cacheName).clear();
        }
    }
}

