/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.service.validator;

import org.apache.commons.validator.GenericValidator;
import org.broadleafcommerce.profile.domain.Customer;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;

@Component(value="blRegistrationValidator")
public class RegistrationValidator {
    public static final String DEFAULT_VALID_NAME_REGEX = "[A-Za-z'. ]{1,80}";
    public static final String DEFAULT_VALID_PASSWORD_REGEX = "[0-9A-Za-z]{4,15}";
    private String validNameRegex = "[A-Za-z'. ]{1,80}";
    private String validPasswordRegex = "[0-9A-Za-z]{4,15}";

    public void validate(Customer customer, String password, String passwordConfirm, Errors errors) {
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"password", (String)"password.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"passwordConfirm", (String)"passwordConfirm.required");
        errors.pushNestedPath("customer");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"firstName", (String)"firstName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"lastName", (String)"lastName.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"emailAddress", (String)"emailAddress.required");
        errors.popNestedPath();
        if (errors.hasErrors()) {
            if (!passwordConfirm.equals(password)) {
                errors.rejectValue("passwordConfirm", "invalid");
            }
            if (!customer.getFirstName().matches(this.validNameRegex)) {
                errors.rejectValue("firstName", "firstName.invalid", null, null);
            }
            if (!customer.getLastName().matches(this.validNameRegex)) {
                errors.rejectValue("lastName", "lastName.invalid", null, null);
            }
            if (!customer.getPassword().matches(this.validPasswordRegex)) {
                errors.rejectValue("password", "password.invalid", null, null);
            }
            if (!password.equals(passwordConfirm)) {
                errors.rejectValue("password", "passwordConfirm.invalid", null, null);
            }
            if (!GenericValidator.isEmail((String)customer.getEmailAddress())) {
                errors.rejectValue("emailAddress", "emailAddress.invalid", null, null);
            }
        }
    }

    public String getValidNameRegex() {
        return this.validNameRegex;
    }

    public void setValidNameRegex(String validNameRegex) {
        this.validNameRegex = validNameRegex;
    }

    public String getValidPasswordRegex() {
        return this.validPasswordRegex;
    }

    public void setValidPasswordRegex(String validPasswordRegex) {
        this.validPasswordRegex = validPasswordRegex;
    }
}

