/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.dao.UserDao;
import org.broadleafcommerce.profile.domain.User;
import org.broadleafcommerce.profile.domain.UserRole;
import org.broadleafcommerce.profile.service.UserService;
import org.broadleafcommerce.profile.util.PasswordChange;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;

@Service(value="blUserService")
public class UserServiceImpl
implements UserService {
    @Resource(name="blUserDao")
    protected UserDao userDao;
    @Resource(name="passwordEncoder")
    protected PasswordEncoder passwordEncoder;

    @Override
    public User saveUser(User user) {
        if (user.getUnencodedPassword() != null) {
            user.setPassword(this.passwordEncoder.encodePassword(user.getUnencodedPassword(), null));
        }
        return this.userDao.save(user);
    }

    @Override
    public List<UserRole> readUserRolesByUserId(Long userId) {
        return this.userDao.readUserRolesByUserId(userId);
    }

    @Override
    public User readUserByEmail(String emailAddress) {
        return this.userDao.readUserByEmail(emailAddress);
    }

    @Override
    public User changePassword(PasswordChange passwordChange) {
        User user = this.readUserByUsername(passwordChange.getUsername());
        user.setUnencodedPassword(passwordChange.getNewPassword());
        user.setPasswordChangeRequired(false);
        user = this.saveUser(user);
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)passwordChange.getUsername(), (Object)passwordChange.getNewPassword(), auth.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)authRequest);
        auth.setAuthenticated(false);
        return user;
    }

    @Override
    public User readUserByUsername(String username) {
        return this.userDao.readUserByUsername(username);
    }

    @Override
    public User readUserById(Long id) {
        return this.userDao.readUserById(id);
    }

    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

