/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.OptimisticLockException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.dao.IdGenerationDao;
import org.broadleafcommerce.profile.domain.IdGeneration;
import org.broadleafcommerce.profile.service.IdGenerationService;
import org.springframework.stereotype.Service;

@Service(value="blIdGenerationService")
public class IdGenerationServiceImpl
implements IdGenerationService {
    private static final Log LOG = LogFactory.getLog(IdGenerationServiceImpl.class);
    @Resource(name="blIdGenerationDao")
    protected IdGenerationDao idGenerationDao;
    protected Map<String, Id> idTypeIdMap = new HashMap<String, Id>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long findNextId(String idType) {
        IdGeneration idGeneration;
        Id id;
        Object object = this.idTypeIdMap;
        synchronized (object) {
            id = this.idTypeIdMap.get(idType);
            if (id == null) {
                id = this.idTypeIdMap.get(idType);
                if (id == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Getting the initial id from the database.");
                    }
                    idGeneration = this.getCurrentIdRange(idType);
                    id = new Id(idGeneration.getBatchStart(), idGeneration.getBatchSize());
                }
                this.idTypeIdMap.put(idType, id);
            }
        }
        object = id;
        synchronized (object) {
            if (id.batchSize == 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Updating batch size for idType " + idType));
                }
                idGeneration = this.getCurrentIdRange(idType);
                id.nextId = idGeneration.getBatchStart();
                id.batchSize = idGeneration.getBatchSize();
            }
            Id id2 = id;
            Long l = id2.nextId;
            Long l2 = id2.nextId = Long.valueOf(id2.nextId + 1L);
            Long retId = l;
            id2 = id;
            l = id2.batchSize;
            l2 = id2.batchSize = Long.valueOf(id2.batchSize - 1L);
            return retId;
        }
    }

    private IdGeneration getCurrentIdRange(String idType) {
        IdGeneration idGeneration = null;
        int retryCount = 0;
        boolean stale = true;
        while (stale) {
            try {
                idGeneration = this.idGenerationDao.findNextId(idType);
                stale = false;
            }
            catch (OptimisticLockException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Error saving batch start for " + idType + ".  Requerying table."));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to retrieve id range for " + idType, e);
            }
            if (retryCount >= 10) {
                throw new RuntimeException("Unable to retrieve id range for " + idType + ". Tried " + retryCount + " times, but the version for this entity continues to be concurrently modified.");
            }
            ++retryCount;
        }
        return idGeneration;
    }

    private class Id {
        public Long nextId;
        public Long batchSize;

        public Id(Long nextId, Long batchSize) {
            this.nextId = nextId;
            this.batchSize = batchSize;
        }
    }
}

