/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.dao.CustomerDao;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.service.CustomerService;
import org.broadleafcommerce.profile.service.IdGenerationService;
import org.broadleafcommerce.profile.service.listener.PostRegistrationObserver;
import org.broadleafcommerce.profile.util.PasswordChange;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service(value="blCustomerService")
public class CustomerServiceImpl
implements CustomerService {
    @Resource(name="blCustomerDao")
    protected CustomerDao customerDao;
    @Resource(name="blIdGenerationService")
    protected IdGenerationService idGenerationService;
    @Resource(name="passwordEncoder")
    protected PasswordEncoder passwordEncoder;
    private final List<PostRegistrationObserver> postRegisterListeners = new ArrayList<PostRegistrationObserver>();

    @Override
    public Customer saveCustomer(Customer customer) {
        return this.saveCustomer(customer, true);
    }

    @Override
    public Customer saveCustomer(Customer customer, boolean register) {
        if (register && !customer.isRegistered()) {
            customer.setRegistered(true);
        }
        if (customer.getUnencodedPassword() != null) {
            customer.setPassword(this.passwordEncoder.encodePassword(customer.getUnencodedPassword(), null));
        }
        if (customer.getUnencodedChallengeAnswer() != null && !customer.getUnencodedChallengeAnswer().equals(customer.getChallengeAnswer())) {
            customer.setChallengeAnswer(this.passwordEncoder.encodePassword(customer.getUnencodedChallengeAnswer(), null));
        }
        return this.customerDao.save(customer);
    }

    @Override
    public Customer registerCustomer(Customer customer, String password, String passwordConfirm) {
        customer.setRegistered(true);
        if (customer.getId() == null) {
            customer.setId(this.idGenerationService.findNextId("org.broadleafcommerce.profile.domain.Customer"));
        }
        customer.setUnencodedPassword(password);
        Customer retCustomer = this.saveCustomer(customer);
        this.notifyPostRegisterListeners(retCustomer);
        return retCustomer;
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        return this.customerDao.readCustomerByEmail(emailAddress);
    }

    @Override
    public Customer changePassword(PasswordChange passwordChange) {
        Customer customer = this.readCustomerByUsername(passwordChange.getUsername());
        customer.setUnencodedPassword(passwordChange.getNewPassword());
        customer.setPasswordChangeRequired(passwordChange.getPasswordChangeRequired());
        customer = this.saveCustomer(customer);
        return customer;
    }

    @Override
    public void addPostRegisterListener(PostRegistrationObserver postRegisterListeners) {
        this.postRegisterListeners.add(postRegisterListeners);
    }

    @Override
    public void removePostRegisterListener(PostRegistrationObserver postRegisterListeners) {
        if (this.postRegisterListeners.contains(postRegisterListeners)) {
            this.postRegisterListeners.remove(postRegisterListeners);
        }
    }

    protected void notifyPostRegisterListeners(Customer customer) {
        for (PostRegistrationObserver listener : this.postRegisterListeners) {
            listener.processRegistrationEvent(customer);
        }
    }

    @Override
    public Customer createCustomerFromId(Long customerId) {
        Customer customer;
        Customer customer2 = customer = customerId != null ? this.readCustomerById(customerId) : null;
        if (customer == null) {
            customer = this.customerDao.create();
            if (customerId != null) {
                customer.setId(customerId);
            } else {
                customer.setId(this.idGenerationService.findNextId("org.broadleafcommerce.profile.domain.Customer"));
            }
        }
        return customer;
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        return this.customerDao.readCustomerByUsername(username);
    }

    @Override
    public Customer readCustomerById(Long id) {
        return this.customerDao.readCustomerById(id);
    }

    public void setCustomerDao(CustomerDao customerDao) {
        this.customerDao = customerDao;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }
}

