/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.service;

import java.util.List;
import javax.annotation.Resource;
import org.broadleafcommerce.profile.dao.CustomerAddressDao;
import org.broadleafcommerce.profile.domain.CustomerAddress;
import org.broadleafcommerce.profile.service.CustomerAddressService;
import org.springframework.stereotype.Service;

@Service(value="blCustomerAddressService")
public class CustomerAddressServiceImpl
implements CustomerAddressService {
    @Resource(name="blCustomerAddressDao")
    protected CustomerAddressDao customerAddressDao;

    @Override
    public CustomerAddress saveCustomerAddress(CustomerAddress customerAddress) {
        List<CustomerAddress> activeCustomerAddresses = this.readActiveCustomerAddressesByCustomerId(customerAddress.getCustomer().getId());
        if (activeCustomerAddresses.size() == 0) {
            customerAddress.getAddress().setDefault(true);
        } else if (customerAddress.getAddress().isDefault()) {
            for (CustomerAddress activeCustomerAddress : activeCustomerAddresses) {
                if (activeCustomerAddress.getId() == customerAddress.getId() || !activeCustomerAddress.getAddress().isDefault()) continue;
                activeCustomerAddress.getAddress().setDefault(false);
                this.customerAddressDao.save(activeCustomerAddress);
            }
        }
        return this.customerAddressDao.save(customerAddress);
    }

    @Override
    public List<CustomerAddress> readActiveCustomerAddressesByCustomerId(Long customerId) {
        return this.customerAddressDao.readActiveCustomerAddressesByCustomerId(customerId);
    }

    @Override
    public CustomerAddress readCustomerAddressById(Long customerAddressId) {
        return this.customerAddressDao.readCustomerAddressById(customerAddressId);
    }

    @Override
    public void makeCustomerAddressDefault(Long customerAddressId, Long customerId) {
        this.customerAddressDao.makeCustomerAddressDefault(customerAddressId, customerId);
    }

    @Override
    public void deleteCustomerAddressById(Long customerAddressId) {
        this.customerAddressDao.deleteCustomerAddressById(customerAddressId);
    }

    @Override
    public CustomerAddress findDefaultCustomerAddress(Long customerId) {
        return this.customerAddressDao.findDefaultCustomerAddress(customerId);
    }

    @Override
    public CustomerAddress create() {
        return this.customerAddressDao.create();
    }
}

