/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.domain.listener;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.broadleafcommerce.profile.domain.annotation.AutoPopulate;

public class TemporalTimestampListener {
    @PrePersist
    @PreUpdate
    public void setTimestamps(Object entity) throws Exception {
        if (entity.getClass().isAnnotationPresent(Entity.class)) {
            Field[] fields = entity.getClass().getDeclaredFields();
            this.setTimestamps(fields, entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimestamps(Field[] fields, Object entity) throws Exception {
        GregorianCalendar cal = null;
        for (Field field : fields) {
            Class<Comparable<Date>> type = field.getType();
            Temporal temporalAnnotation = field.getAnnotation(Temporal.class);
            if (temporalAnnotation != null) {
                if (!field.isAnnotationPresent(Column.class)) continue;
                field.setAccessible(true);
                try {
                    if (!TemporalType.TIMESTAMP.equals((Object)temporalAnnotation.value()) || !field.isAnnotationPresent(AutoPopulate.class) || field.get(entity) != null && !field.getAnnotation(AutoPopulate.class).autoUpdateValue()) continue;
                    if (type.isAssignableFrom(Date.class)) {
                        if (cal == null) {
                            cal = new GregorianCalendar();
                        }
                        field.set(entity, cal.getTime());
                        continue;
                    }
                    if (!type.isAssignableFrom(Calendar.class)) continue;
                    if (cal == null) {
                        cal = new GregorianCalendar();
                    }
                    field.set(entity, cal);
                    continue;
                }
                finally {
                    field.setAccessible(false);
                }
            }
            if (!field.isAnnotationPresent(Embedded.class)) continue;
            field.setAccessible(true);
            try {
                this.setTimestamps(field.getType().getDeclaredFields(), field.get(entity));
            }
            finally {
                field.setAccessible(false);
            }
        }
    }
}

