/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.profile.domain.Country;
import org.broadleafcommerce.profile.domain.CountryImpl;
import org.broadleafcommerce.profile.domain.State;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_STATE")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class StateImpl
implements State {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="ABBREVIATION")
    protected String abbreviation;
    @Column(name="NAME", nullable=false)
    protected String name;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CountryImpl.class, optional=false)
    @JoinColumn(name="COUNTRY")
    protected Country country;

    @Override
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Override
    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    @Override
    public void setCountry(Country country) {
        this.country = country;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abbreviation == null ? 0 : this.abbreviation.hashCode());
        result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateImpl other = (StateImpl)obj;
        if (this.abbreviation == null ? other.abbreviation != null : !this.abbreviation.equals(other.abbreviation)) {
            return false;
        }
        if (this.country == null ? other.country != null : !this.country.equals(other.country)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

