/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.domain;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.domain.CustomerImpl;
import org.broadleafcommerce.profile.domain.CustomerRole;
import org.broadleafcommerce.profile.domain.Role;
import org.broadleafcommerce.profile.domain.RoleImpl;
import org.broadleafcommerce.profile.domain.listener.TemporalTimestampListener;

@Entity
@EntityListeners(value={TemporalTimestampListener.class})
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER_ROLE")
public class CustomerRoleImpl
implements CustomerRole {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="CustomerRoleId", strategy=GenerationType.TABLE)
    @TableGenerator(name="CustomerRoleId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="CustomerRoleImpl", allocationSize=50)
    @Column(name="CUSTOMER_ROLE_ID")
    protected Long id;
    @ManyToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE}, targetEntity=CustomerImpl.class, optional=false)
    @JoinColumn(name="CUSTOMER_ID")
    protected Customer customer;
    @OneToOne(cascade={CascadeType.ALL}, targetEntity=RoleImpl.class, optional=false)
    @JoinColumn(name="ROLE_ID")
    protected Role role;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Customer getCustomer() {
        return this.customer;
    }

    @Override
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public void setRole(Role role) {
        this.role = role;
    }

    @Override
    public String getRoleName() {
        return this.role.getRoleName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.customer == null ? 0 : this.customer.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomerRoleImpl other = (CustomerRoleImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.customer == null ? other.customer != null : !this.customer.equals(other.customer)) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }
}

