/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.domain;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.broadleafcommerce.common.domain.Auditable;
import org.broadleafcommerce.profile.domain.Customer;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_CUSTOMER", uniqueConstraints={@UniqueConstraint(columnNames={"USER_NAME"})})
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class CustomerImpl
implements Customer {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="CUSTOMER_ID")
    protected Long id;
    @Embedded
    protected Auditable auditable = new Auditable();
    @Column(name="USER_NAME")
    protected String username;
    @Column(name="PASSWORD")
    protected String password;
    @Column(name="FIRST_NAME")
    protected String firstName;
    @Column(name="LAST_NAME")
    protected String lastName;
    @Column(name="EMAIL_ADDRESS")
    protected String emailAddress;
    @Column(name="CHALLENGE_QUESTION_ID")
    protected Long challengeQuestionId;
    @Column(name="CHALLENGE_ANSWER")
    protected String challengeAnswer;
    @Column(name="PASSWORD_CHANGE_REQUIRED")
    protected boolean passwordChangeRequired = false;
    @Column(name="RECEIVE_EMAIL")
    protected boolean receiveEmail = true;
    @Column(name="IS_REGISTERED")
    protected boolean registered = false;
    @Transient
    protected String unencodedPassword;
    @Transient
    protected String unencodedChallengeAnswer;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public boolean isPasswordChangeRequired() {
        return this.passwordChangeRequired;
    }

    @Override
    public void setPasswordChangeRequired(boolean passwordChangeRequired) {
        this.passwordChangeRequired = passwordChangeRequired;
    }

    @Override
    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Override
    public String getLastName() {
        return this.lastName;
    }

    @Override
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Override
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Override
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @Override
    public Long getChallengeQuestionId() {
        return this.challengeQuestionId;
    }

    @Override
    public void setChallengeQuestionId(Long challengeQuestionId) {
        this.challengeQuestionId = challengeQuestionId;
    }

    @Override
    public String getChallengeAnswer() {
        return this.challengeAnswer;
    }

    @Override
    public void setChallengeAnswer(String challengeAnswer) {
        this.challengeAnswer = challengeAnswer;
    }

    @Override
    public String getUnencodedPassword() {
        return this.unencodedPassword;
    }

    @Override
    public void setUnencodedPassword(String unencodedPassword) {
        this.unencodedPassword = unencodedPassword;
    }

    @Override
    public boolean isReceiveEmail() {
        return this.receiveEmail;
    }

    @Override
    public void setReceiveEmail(boolean receiveEmail) {
        this.receiveEmail = receiveEmail;
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    @Override
    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    @Override
    public String getUnencodedChallengeAnswer() {
        return this.unencodedChallengeAnswer;
    }

    @Override
    public void setUnencodedChallengeAnswer(String unencodedChallengeAnswer) {
        this.unencodedChallengeAnswer = unencodedChallengeAnswer;
    }

    @Override
    public Auditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(Auditable auditable) {
        this.auditable = auditable;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomerImpl other = (CustomerImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }
}

