/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.profile.dao.UserDao;
import org.broadleafcommerce.profile.domain.User;
import org.broadleafcommerce.profile.domain.UserRole;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blUserDao")
public class UserDaoImpl
implements UserDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public User readUserByUsername(String username) {
        Query query = this.em.createNamedQuery("BC_sREAD_USER_BY_USER_NAME");
        query.setParameter("username", (Object)username);
        List users = query.getResultList();
        return users == null || users.isEmpty() ? null : (User)users.get(0);
    }

    @Override
    public User readUserByEmail(String emailAddress) {
        Query query = this.em.createNamedQuery("BC_READ_USER_BY_EMAIL");
        query.setParameter("email", (Object)emailAddress);
        List users = query.getResultList();
        return users == null || users.isEmpty() ? null : (User)users.get(0);
    }

    @Override
    public List<UserRole> readUserRolesByUserId(Long userId) {
        Query query = this.em.createNamedQuery("BC_READ_ROLES_BY_USER_ID");
        query.setParameter("userId", (Object)userId);
        return query.getResultList();
    }

    @Override
    public User save(User user) {
        User retUser = user;
        if (retUser.getId() == null) {
            this.em.persist((Object)retUser);
        } else {
            retUser = (User)this.em.merge((Object)retUser);
        }
        return retUser;
    }

    @Override
    public User readUserById(Long id) {
        return (User)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.domain.User"), (Object)id);
    }
}

