/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.profile.dao.StateDao;
import org.broadleafcommerce.profile.domain.Country;
import org.broadleafcommerce.profile.domain.State;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blStateDao")
public class StateDaoImpl
implements StateDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public State findStateByAbbreviation(String abbreviation) {
        return (State)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.domain.State"), (Object)abbreviation);
    }

    @Override
    public List<State> findStates() {
        Query query = this.em.createNamedQuery("BC_FIND_STATES");
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    @Override
    public List<State> findStates(String countryAbbreviation) {
        Query query = this.em.createNamedQuery("BC_FIND_STATES_BY_COUNTRY_ABBREVIATION");
        query.setParameter("countryAbbreviation", (Object)countryAbbreviation);
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    public Country findCountryByShortName(String shortName) {
        return (Country)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.domain.Country"), (Object)shortName);
    }

    public List<Country> findCountries() {
        Query query = this.em.createNamedQuery("BC_FIND_COUNTRIES");
        query.setHint(this.getQueryCacheableKey(), (Object)true);
        return query.getResultList();
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }

    @Override
    public State create() {
        return (State)this.entityConfiguration.createEntityInstance(State.class.getName());
    }
}

