/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.dao;

import javax.annotation.Resource;
import javax.persistence.EntityExistsException;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.profile.dao.IdGenerationDao;
import org.broadleafcommerce.profile.domain.IdGeneration;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.springframework.stereotype.Repository;

@Repository(value="blIdGenerationDao")
public class IdGenerationDaoImpl
implements IdGenerationDao {
    private static final Log LOG = LogFactory.getLog(IdGenerationDaoImpl.class);
    protected Long defaultBatchSize = 100L;
    protected Long defaultBatchStart = 1L;
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;
    protected String queryCacheableKey = "org.hibernate.cacheable";

    @Override
    public IdGeneration findNextId(String idType) throws OptimisticLockException, Exception {
        IdGeneration response;
        Query query = this.em.createNamedQuery("BC_FIND_NEXT_ID");
        query.setParameter("idType", (Object)idType);
        query.setHint(this.getQueryCacheableKey(), (Object)false);
        try {
            IdGeneration idGeneration = (IdGeneration)query.getSingleResult();
            response = (IdGeneration)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.domain.IdGeneration");
            response.setBatchSize(idGeneration.getBatchSize());
            response.setBatchStart(idGeneration.getBatchStart());
            Long originalBatchStart = idGeneration.getBatchStart();
            idGeneration.setBatchStart(originalBatchStart + idGeneration.getBatchSize());
            if (idGeneration.getBegin() != null) {
                response.setBegin(idGeneration.getBegin());
                if (idGeneration.getBatchStart() < idGeneration.getBegin()) {
                    idGeneration.setBatchStart(idGeneration.getBegin());
                    response.setBatchStart(idGeneration.getBatchStart());
                }
            }
            if (idGeneration.getEnd() != null) {
                response.setEnd(idGeneration.getEnd());
                if (idGeneration.getBatchStart() > idGeneration.getEnd()) {
                    response.setBatchSize(idGeneration.getEnd() - originalBatchStart + 1L);
                    if (idGeneration.getBegin() != null) {
                        idGeneration.setBatchStart(idGeneration.getBegin());
                    } else {
                        idGeneration.setBatchStart(this.getDefaultBatchStart());
                    }
                }
            }
            response.setType(idGeneration.getType());
            this.em.merge((Object)idGeneration);
            this.em.flush();
        }
        catch (NoResultException nre) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("No row found in idGenerator table for " + idType + " creating row."));
            }
            response = (IdGeneration)this.entityConfiguration.createEntityInstance("org.broadleafcommerce.profile.domain.IdGeneration");
            response.setType(idType);
            response.setBegin(null);
            response.setEnd(null);
            response.setBatchStart(this.getDefaultBatchStart());
            response.setBatchSize(this.getDefaultBatchSize());
            try {
                this.em.persist((Object)response);
                this.em.flush();
            }
            catch (EntityExistsException e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)("Error inserting row id generation for idType " + idType + ".  Requerying table."));
                }
                return this.findNextId(idType);
            }
        }
        return response;
    }

    public Long getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    public void setDefaultBatchSize(Long defaultBatchSize) {
        this.defaultBatchSize = defaultBatchSize;
    }

    public Long getDefaultBatchStart() {
        return this.defaultBatchStart;
    }

    public void setDefaultBatchStart(Long defaultBatchStart) {
        this.defaultBatchStart = defaultBatchStart;
    }

    public String getQueryCacheableKey() {
        return this.queryCacheableKey;
    }

    public void setQueryCacheableKey(String queryCacheableKey) {
        this.queryCacheableKey = queryCacheableKey;
    }
}

