/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.profile.dao;

import java.util.List;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.broadleafcommerce.profile.dao.CustomerDao;
import org.broadleafcommerce.profile.domain.Customer;
import org.broadleafcommerce.profile.util.EntityConfiguration;
import org.broadleafcommerce.time.SystemTime;
import org.springframework.stereotype.Repository;

@Repository(value="blCustomerDao")
public class CustomerDaoImpl
implements CustomerDao {
    @PersistenceContext(unitName="blPU")
    protected EntityManager em;
    @Resource(name="blEntityConfiguration")
    protected EntityConfiguration entityConfiguration;

    @Override
    public Customer readCustomerById(Long id) {
        return (Customer)this.em.find(this.entityConfiguration.lookupEntityClass("org.broadleafcommerce.profile.domain.Customer"), (Object)id);
    }

    @Override
    public Customer readCustomerByUsername(String username) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_USER_NAME");
        query.setParameter("username", (Object)username);
        List customers = query.getResultList();
        return customers == null || customers.isEmpty() ? null : (Customer)customers.get(0);
    }

    @Override
    public Customer readCustomerByEmail(String emailAddress) {
        Query query = this.em.createNamedQuery("BC_READ_CUSTOMER_BY_EMAIL");
        query.setParameter("email", (Object)emailAddress);
        List customers = query.getResultList();
        return customers == null || customers.isEmpty() ? null : (Customer)customers.get(0);
    }

    @Override
    public Customer save(Customer customer) {
        if (customer.getAuditable() != null) {
            customer.getAuditable().setDateUpdated(SystemTime.asDate());
        }
        if (customer.getId() == null) {
            this.em.persist((Object)customer);
        } else {
            customer = (Customer)this.em.merge((Object)customer);
        }
        return customer;
    }

    @Override
    public Customer create() {
        Customer customer = (Customer)this.entityConfiguration.createEntityInstance(Customer.class.getName());
        customer.getAuditable().setDateCreated(SystemTime.asDate());
        return customer;
    }
}

