/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.payment;

import java.io.Serializable;
import java.util.Hashtable;
import java.util.Map;

public class CreditCardType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, CreditCardType> types = new Hashtable<String, CreditCardType>();
    public static CreditCardType MASTERCARD = new CreditCardType("MASTERCARD");
    public static CreditCardType VISA = new CreditCardType("VISA");
    public static CreditCardType AMEX = new CreditCardType("AMEX");
    public static CreditCardType DINERSCLUB_CARTEBLANCHE = new CreditCardType("DINERSCLUB_CARTEBLANCHE");
    public static CreditCardType DISCOVER = new CreditCardType("DISCOVER");
    public static CreditCardType ENROUTE = new CreditCardType("ENROUTE");
    public static CreditCardType JCB = new CreditCardType("JCB");
    private String type;

    public static CreditCardType getInstance(String type) {
        return types.get(type);
    }

    public CreditCardType() {
    }

    public CreditCardType(String type) {
        this.setType(type);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        if (!types.containsKey(type)) {
            types.put(type, this);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CreditCardType other = (CreditCardType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

