/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.extensibility.context.merge;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.extensibility.context.merge.MergePoint;
import org.broadleafcommerce.extensibility.context.merge.exceptions.MergeException;
import org.broadleafcommerce.extensibility.context.merge.exceptions.MergeManagerSetupException;
import org.broadleafcommerce.extensibility.context.merge.handlers.MergeHandler;
import org.broadleafcommerce.extensibility.context.merge.handlers.MergeHandlerAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MergeManager {
    public static final String MERGE_DEFINITION_SYSTEM_PROPERTY = "org.broadleafcommerce.extensibility.context.merge.handlers.merge.properties";
    private static final Log LOG = LogFactory.getLog(MergeManager.class);
    private static DocumentBuilder builder;
    private MergeHandler[] handlers;

    public MergeManager() throws MergeManagerSetupException {
        try {
            Properties props = this.loadProperties();
            this.setHandlers(props);
        }
        catch (IOException e) {
            throw new MergeManagerSetupException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MergeManagerSetupException(e);
        }
        catch (IllegalAccessException e) {
            throw new MergeManagerSetupException(e);
        }
        catch (InstantiationException e) {
            throw new MergeManagerSetupException(e);
        }
    }

    public InputStream merge(InputStream stream1, InputStream stream2) throws MergeException {
        try {
            Document doc1 = builder.parse(stream1);
            Document doc2 = builder.parse(stream2);
            ArrayList<Node> exhaustedNodes = new ArrayList<Node>();
            for (int j = 0; j < this.handlers.length; ++j) {
                MergePoint point;
                Node[] list;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Processing handler: " + this.handlers[j].getXPath()));
                }
                if ((list = (point = new MergePoint(this.handlers[j], doc1, doc2)).merge(exhaustedNodes)) == null) continue;
                for (int x = 0; x < list.length; ++x) {
                    exhaustedNodes.add(list[x]);
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer xmlTransformer = tFactory.newTransformer();
            xmlTransformer.setOutputProperty("version", "1.0");
            xmlTransformer.setOutputProperty("encoding", "UTF-8");
            xmlTransformer.setOutputProperty("method", "xml");
            xmlTransformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc1);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(baos));
            StreamResult result = new StreamResult(writer);
            xmlTransformer.transform(source, result);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (Throwable e) {
            throw new MergeException(e);
        }
    }

    private void setHandlers(Properties props) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        ArrayList<MergeHandler> handlers = new ArrayList<MergeHandler>();
        String[] keys = new String[]{};
        keys = props.keySet().toArray(keys);
        for (int j = 0; j < keys.length; ++j) {
            if (!keys[j].startsWith("handler.")) continue;
            MergeHandler temp = (MergeHandler)Class.forName(props.getProperty(keys[j])).newInstance();
            String name = keys[j].substring(8, keys[j].length());
            temp.setName(name);
            String priority = props.getProperty("priority." + name);
            if (priority != null) {
                temp.setPriority(Integer.parseInt(priority));
            }
            String xpath = props.getProperty("xpath." + name);
            if (priority != null) {
                temp.setXPath(xpath);
            }
            handlers.add(temp);
        }
        MergeHandler[] explodedView = new MergeHandler[]{};
        explodedView = handlers.toArray(explodedView);
        Comparator<Object> nameCompare = new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                return ((MergeHandler)arg0).getName().compareTo(((MergeHandler)arg1).getName());
            }
        };
        Arrays.sort(explodedView, nameCompare);
        ArrayList<MergeHandler> finalHandlers = new ArrayList<MergeHandler>();
        for (int j = 0; j < explodedView.length; ++j) {
            MergeHandler temp = explodedView[j];
            if (temp.getName().indexOf(".") >= 0) {
                final String parentName = temp.getName().substring(0, temp.getName().lastIndexOf("."));
                int pos = Arrays.binarySearch(explodedView, new MergeHandlerAdapter(){

                    @Override
                    public String getName() {
                        return parentName;
                    }
                }, nameCompare);
                if (pos < 0) continue;
                MergeHandler[] parentHandlers = explodedView[pos].getChildren();
                Object[] newHandlers = new MergeHandler[parentHandlers.length + 1];
                System.arraycopy(parentHandlers, 0, newHandlers, 0, parentHandlers.length);
                newHandlers[newHandlers.length - 1] = temp;
                Arrays.sort(newHandlers);
                explodedView[pos].setChildren((MergeHandler[])newHandlers);
                continue;
            }
            finalHandlers.add(temp);
        }
        this.handlers = new MergeHandler[0];
        this.handlers = finalHandlers.toArray(this.handlers);
        Arrays.sort(this.handlers);
    }

    private Properties loadProperties() throws IOException {
        Properties props;
        Properties defaultProperties = new Properties();
        defaultProperties.load(MergeManager.class.getResourceAsStream("default.properties"));
        String overrideFileClassPath = System.getProperty(MERGE_DEFINITION_SYSTEM_PROPERTY);
        if (overrideFileClassPath != null) {
            props = new Properties(defaultProperties);
            props.load(MergeManager.class.getClassLoader().getResourceAsStream(overrideFileClassPath));
        } else {
            props = defaultProperties;
        }
        return props;
    }

    static {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Unable to create document builder", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

