/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.extensibility.context;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.extensibility.context.merge.MergeXmlConfigResource;
import org.broadleafcommerce.extensibility.context.merge.exceptions.MergeException;
import org.broadleafcommerce.extensibility.context.merge.exceptions.MergeManagerSetupException;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;

public class MergeApplicationContextXmlConfigResource
extends MergeXmlConfigResource {
    private static final Log LOG = LogFactory.getLog(MergeApplicationContextXmlConfigResource.class);

    public Resource[] getConfigResources(InputStream[] sources, InputStream[] patches) throws BeansException {
        Resource[] configResources = null;
        InputStream merged = null;
        try {
            merged = this.merge(sources);
            byte[] mergedArray = this.buildArrayFromStream(merged);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Merged Stage1 Sources: \n" + this.serialize(new ByteArrayInputStream(mergedArray))));
            }
            if (patches != null) {
                InputStream[] patches2 = new InputStream[patches.length + 1];
                patches2[0] = new ByteArrayInputStream(mergedArray);
                System.arraycopy(patches, 0, patches2, 1, patches.length);
                merged = this.merge(patches2);
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            boolean eof = false;
            while (!eof) {
                int temp = merged.read();
                if (temp == -1) {
                    eof = true;
                    continue;
                }
                baos.write(temp);
            }
            configResources = new Resource[]{new ByteArrayResource(baos.toByteArray())};
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Merged ApplicationContext Including Patches: \n" + this.serialize(configResources[0])));
            }
        }
        catch (MergeException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (MergeManagerSetupException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        catch (IOException e) {
            throw new FatalBeanException("Unable to merge source and patch locations", (Throwable)e);
        }
        finally {
            if (merged != null) {
                try {
                    merged.close();
                }
                catch (Throwable e) {
                    LOG.error((Object)"Unable to merge source and patch locations", e);
                }
            }
        }
        return configResources;
    }
}

